package catalog

import (
	"fmt"

	"github.com/jinzhu/gorm"
	"github.com/sirupsen/logrus"
)

// Account represents an AWS account (or bare metal)
type Account struct {
	gorm.Model
	Alias        string `gorm:"size:64"`
	Description  string `gorm:"size:2000"`
	AWSAccountID string `gorm:"not null;unique"`
	OrgID        uint
	Components   []*Component
}

func (a *Account) Org() *Org {
	if a.OrgID == 0 {
		return nil
	} else {
		// Try to get the org, but if we can't just return nil
		org, err := GetCatalog().GetOrgByID(a.OrgID)
		if err != nil {
			logrus.Warnf("failure getting Org data for Account: %s", a.Alias)
			return nil
		}
		return org
	}
}

// URL returns the base URL for the resource
func (f *Account) URL() string {
	return fmt.Sprintf("/accounts/%d", f.ID)
}
