package catalog

var baseServiceTypes = []*ServiceType{
	{Name: "Internal Operational Service", Label: "internal-ops", Description: "Internal only service that support operations, but not the product directly. e.g. DNS, proxy"},
	{Name: "External Product Service", Label: "external-product", Description: "Externally facing services that support the Twitch product."},
	{Name: "Internal Product Service", Label: "internal-product", Description: "Internal-only service that supports the Twitch product."},
}

// AddBaseServiceTypes is for testing only. It add the basic service types
func AddBaseServiceTypes() {
	c := GetCatalog()
	for _, st := range baseServiceTypes {
		err := c.AddServiceType(st)
		if err != nil {
			panic(err)
		}
	}
}
