package catalog

// Catalog interface defines the set of functions that can be used to interface with any service catalog implementation
type Catalog interface {
	GetComponentByID(uint) (*Component, error)
	GetServiceByID(uint) (*Service, error)
	GetFeatureByID(uint) (*Feature, error)
	GetMetricByID(uint) (*Metric, error)
	GetQueryByID(uint) (*Query, error)
	GetServiceTypeByID(uint) (*ServiceType, error)
	GetTeamByID(uint) (*Team, error)
	GetAccountByID(uint) (*Account, error)
	GetOrgByID(uint) (*Org, error)
	GetAttributeByID(uint) (*Attribute, error)
	GetServiceDependencyByID(uint) (*ServiceDependency, error)

	GetComponents(map[string]interface{}) ([]*Component, error)
	GetServices(map[string]interface{}) ([]*Service, error)
	GetTeams() []*Team
	GetServiceTypes() ([]*ServiceType, error)
	GetFeatures() ([]*Feature, error)
	GetMetrics(map[string]interface{}) []*Metric
	GetQueries(map[string]interface{}) []*Query
	GetAccounts(map[string]interface{}) []*Account
	GetOrgs(map[string]interface{}) []*Org
	GetServiceAudits(map[string]interface{}) []*ServiceAudit
	GetLatestServiceAudits(map[string]interface{}) []*ServiceAudit
	GetLogRecords(map[string]interface{}, int, int) []*LogRecord
	GetAttributes(map[string]interface{}) ([]*Attribute, error)
	GetServiceDependencies(map[string]interface{}) ([]*ServiceDependency, error)

	GetServiceAuditTypes() []string

	AddComponent(*Component) error
	AddService(*Service) error
	AddServiceType(*ServiceType) error
	AddTeam(*Team) error
	AddMetric(*Metric) error
	AddQuery(*Query) error
	AddAccount(*Account) error
	AddOrg(*Org) error
	AddServiceAudit(*ServiceAudit) error
	AddLogRecord(*LogRecord) error
	AddAttribute(*Attribute) error
	AddServiceDependency(*ServiceDependency) error

	DeleteComponent(*Component) error
	DeleteService(*Service) error
	DeleteTeam(*Team) error
	DeleteMetric(*Metric) error
	DeleteQuery(*Query) error
	DeleteAccount(*Account) error
	DeleteOrg(*Org) error
	DeleteAttribute(*Attribute) error
	DeleteServiceDependency(*ServiceDependency) error

	GetRootFeatures() []*Feature
	UnknownComponents() []*Component

	GetComponentsByIDs([]uint) ([]*Component, error)
	GetServicesByIDs([]uint) ([]*Service, error)
	GetFeaturesByIDs([]uint) ([]*Feature, error)
	GetMetricsByIDs([]uint) ([]*Metric, error)
	GetQueriesByIDs([]uint) ([]*Query, error)
	GetTeamsByIDs([]uint) ([]*Team, error)
	GetAccountsByIDs([]uint) ([]*Account, error)
	GetOrgsByIDs([]uint) ([]*Org, error)
	GetAttributesByIDs([]uint) ([]*Attribute, error)
	GetServiceDependenciesByIDs([]uint) ([]*ServiceDependency, error)

	GetComponentsComplete([]uint, map[string]interface{}) ([]*Component, error)
	GetServicesComplete([]uint, map[string]interface{}) ([]*Service, error)
	GetFeaturesComplete([]uint, map[string]interface{}) ([]*Feature, error)
	GetMetricsComplete([]uint, map[string]interface{}) ([]*Metric, error)
	GetQueriesComplete([]uint, map[string]interface{}) ([]*Query, error)
	GetTeamsComplete([]uint, map[string]interface{}) ([]*Team, error)
	GetAccountsComplete([]uint, map[string]interface{}) ([]*Account, error)
	GetOrgsComplete([]uint, map[string]interface{}) ([]*Org, error)
	GetAttributesComplete([]uint, map[string]interface{}) ([]*Attribute, error)
	GetServiceDependenciesComplete([]uint, map[string]interface{}) ([]*ServiceDependency, error)
}

// GetCatalog returns the corect implemtation of the catalog interface for use
func GetCatalog() Catalog {
	return getDBCatalog()
}
