package catalog

import (
	"fmt"

	"github.com/jinzhu/gorm"
)

// Feature Defines the schema for the features table and contains the information about a feature
type Feature struct {
	gorm.Model
	Label       string
	Name        string
	Description string `gorm:"size:2000"`

	Metrics   []*Metric `gorm:"many2many:feature_metric;"`
	Children  []*Feature
	FeatureID *uint //this is the ParentID but gorm requires it to be called this
	Feature   *Feature
}

// URL returns the base URL for the resource
func (f *Feature) URL() string {
	return fmt.Sprintf("/features/%d", f.ID)
}

// Parent returns the Feature that is the features parent
func (f *Feature) Parent() (*Feature, error) {
	parent, err := GetCatalog().GetFeatureByID(*f.FeatureID)
	if err != nil {
		return nil, err
	}
	return parent, nil
}
