package catalog

import (
	"fmt"

	"github.com/jinzhu/gorm"
)

// Org represents a Twitch organization.
type Org struct {
	gorm.Model
	Name        string `gorm:"not null;unique"`
	Label       string
	Description string `gorm:"size:2000"`
	OrgID       uint   // This is the Parent but gorm requires it to be called this
	Accounts    []*Account
	Teams       []*Team
}

// URL returns the base URL for the resource
func (f *Org) URL() string {
	return fmt.Sprintf("/orgs/%d", f.ID)
}
