package catalog

import (
	"fmt"

	"github.com/jinzhu/gorm"
)

// Team Defines the schema for the teams table and contains the information about a team
type Team struct {
	gorm.Model
	Name        string
	Label       string
	Email       string
	Slack       string
	Description string `gorm:"size:2000"`
	OrgID       uint
	Org         *Org
}

// URL returns the endpoint for the show page for a specific team
func (t *Team) URL() string {
	return "/teams/" + fmt.Sprint(t.ID)
}
