package catalog

import (
	"errors"
	"fmt"
	"html/template"

	"code.justin.tv/availability/goracle/dateutil"

	"github.com/russross/blackfriday"
	uuid "github.com/satori/go.uuid"
)

func markdowner(args ...interface{}) template.HTML {
	s := blackfriday.MarkdownCommon([]byte(fmt.Sprintf("%s", args...)))
	return template.HTML(s)
}

func dict(values ...interface{}) (map[string]interface{}, error) {
	if len(values)%2 != 0 {
		return nil, errors.New("invalid dict call")
	}
	dict := make(map[string]interface{}, len(values)/2)
	for i := 0; i < len(values); i += 2 {
		key, ok := values[i].(string)
		if !ok {
			return nil, errors.New("dict keys must be strings")
		}
		dict[key] = values[i+1]
	}
	return dict, nil
}

var counter int

func inc() int {
	counter = counter + 1
	return counter
}

func getuuid() string {
	u := uuid.NewV4()
	return u.String()
}

func serviceaudittypemap(sas []*ServiceAudit) map[string]*ServiceAudit {
	typeMap := make(map[string]*ServiceAudit)
	for _, sa := range sas {
		t := sa.AuditType
		typeMap[t] = sa
	}
	return typeMap
}

// TemplateFuncs returns the functions from catalog that will be passed to the template parser
func TemplateFuncs() map[string]interface{} {
	return map[string]interface{}{
		"DateStr":             dateutil.DateStr,
		"Markdown":            markdowner,
		"Dict":                dict,
		"Inc":                 inc,
		"UUID":                getuuid,
		"ServiceAuditTypeMap": serviceaudittypemap,
	}
}
