package dateutil

import (
	"time"

	"github.com/jinzhu/now"
)

// DateStr returns the y-m-d string representing the date
func DateStr(date time.Time) string {
	return date.Format("2006-01-02")
}

// Returns the beginning of the current ISO week that this day is part of
func BeginningOfISOWeek(t time.Time) time.Time {
	return now.New(t).Monday()
}
