package main

import (
	"fmt"
	"os"

	"code.justin.tv/availability/goracle/catalog"
	"code.justin.tv/availability/goracle/errorhandling"
	"code.justin.tv/availability/hms-esk/pkg/api"
	"code.justin.tv/availability/hms-esk/pkg/config"
	"code.justin.tv/availability/hms-esk/pkg/datamanager"

	"github.com/dsoo/rollrus"
	"github.com/jasonlvhit/gocron"
	"github.com/sirupsen/logrus"
)

func setupLogging() {
	rollrus.SetupLogging(config.Config.RollbarAccessToken, config.Config.RollbarEnvironment)
	loglevel, err := logrus.ParseLevel(config.Config.LogLevel)
	if err != nil {
		logrus.Fatalf("Couldn't parse log level %s: %s", config.Config.LogLevel, err)
	}
	logrus.SetLevel(loglevel)
}

func setupConfig() {
	if len(os.Args) == 2 {
		if err := config.ParseConfig(os.Args[1]); err != nil {
			logrus.Fatalf("Error reading TOML config -- %s", err)
		}
	}

}
func startGocron() {
}

func main() {
	setupConfig()
	setupLogging()
	defer errorhandling.PanicHandler()

	var dsn string
	var username, password, endpoint string = config.CatalogDBUsername(), config.CatalogDBPassword(), config.CatalogDBEndpoint()
	if username != "" && password != "" && endpoint != "" {
		dsn = fmt.Sprintf("mysql://%s:%s@tcp(%s)/catalogdb?parseTime=True", username, password, endpoint)
	} else {
		unset := ""
		if username == "" {
			unset = unset + " username"
		}
		if password == "" {
			unset = unset + " password"
		}
		if endpoint == "" {
			unset = unset + " endpoint"
		}
		logrus.Fatalf("No%s specified in configuration", unset)
	}
	catalog.SetupDB(dsn)
	defer catalog.CloseDB()

	datamanager.InitDataManagers()
	datamanager.UpdateMetricData()

	gocron.Every(5).Minutes().Do(func() {
		datamanager.UpdateMetricData()
	})
	crondone := gocron.Start()

	// Run the web server
	api.RunServer()

	// Send message to cron to stop it from running
	crondone <- true
	logrus.Info("Exiting")
}
