package apihandlers

import (
	"testing"
	"time"

	"code.justin.tv/availability/hms-esk/pkg/datamanager"
	"code.justin.tv/availability/hms-esk/pkg/datasource"
	"github.com/jinzhu/now"
	"github.com/stretchr/testify/assert"
)

// Tests for get current

func TestGetCurrent(t *testing.T) {
	endDate := now.BeginningOfDay()
	dm := datamanager.NewDataManagerTest(1, "string", datasource.NewMockDataSource(1, "string"), 35)
	c, to, w := getCurrent(dm, endDate)
	assert.NotNil(t, c, "current should not be nil")
	assert.NotNil(t, to, "today should not be nil")
	assert.NotNil(t, w, "weektodate should not be nil")
}

func TestGetCurrentNotToday(t *testing.T) {
	endDate := now.BeginningOfDay().Add(time.Hour * -1 * 24)
	dm := datamanager.NewDataManagerTest(1, "string", datasource.NewMockDataSource(1, "string"), 35)
	c, to, w := getCurrent(dm, endDate)
	assert.Nil(t, c, "current should be nil")
	assert.Nil(t, to, "today should be nil")
	assert.Nil(t, w, "weektodate should be nil")
}
