package apihandlers

import (
	"fmt"
	"net/http"

	"code.justin.tv/availability/goracle/catalog"
	"code.justin.tv/availability/hms-esk/pkg/datamanager"
	"github.com/sirupsen/logrus"
)

func ResetHandler(w http.ResponseWriter, r *http.Request) {

	options := r.URL.Query()
	metric, err := getmetric(options)
	if err != nil {
		logrus.Info("Unable to find the item requested.")
		HandleAPIErrors(w, []error{err}, 404)
		return
	}
	datamanager.RestartDataManagerMetric(metric)
	w.Header().Set("Content-Type", "application/json; charset=UTF-8")
	w.WriteHeader(200)

}

func getmetric(options map[string][]string) (*catalog.Metric, error) {
	if len(options["metric"]) == 1 {
		id, _ := StringToUint(options["metric"][0])
		item, err := catalog.GetCatalog().GetMetricByID(id)
		return item, err

	}
	return nil, fmt.Errorf("A metric id must be passed.")
}
