package apihandlers

import (
	"encoding/json"
	"net/http"
	"time"

	"github.com/sirupsen/logrus"

	"code.justin.tv/availability/hms-esk/pkg/datamanager"
)

func UnhealthyHandler(w http.ResponseWriter, r *http.Request) {
	options := r.URL.Query()
	endDate, startDate, errs := parseCommon(options)
	if len(errs) > 0 {
		HandleAPIErrors(w, errs, 400)
		return
	}
	days := daysDiff(endDate, startDate) + 1

	item, err := getItem(options)
	if err != nil {
		logrus.Warn("Unable to find the item requested.")
		HandleAPIErrors(w, []error{err}, 404)
		return
	}
	processing := startDate
	data := []uint{}
	seen := map[uint]uint{}
	// unhealthy := []*catalog.Metric{}
	for i := 0; i < days; i++ {
		unhealthy := datamanager.UnavailableMetrics(item, processing)
		for _, metric := range unhealthy {
			if _, ok := seen[metric.ID]; !ok {
				data = append(data, metric.ID)
				seen[metric.ID] = metric.ID
			}
		}
		processing = processing.Add(time.Hour * 24)
	}
	returnJSON, err := json.Marshal(data)
	if err != nil {
		HandleAPIErrors(w, []error{err}, 500)
		return
	}
	w.Header().Set("Content-Type", "application/json; charset=UTF-8")
	w.WriteHeader(200)
	w.Write(returnJSON)
}
