package datamanager

import "code.justin.tv/availability/goracle/catalog"

func Rollup(i interface{}) []*catalog.Metric {
	if f, ok := i.(*catalog.Feature); ok {
		return RollupFeature(f)
	}
	if s, ok := i.(*catalog.Service); ok {
		return RollupService(s)
	}
	if c, ok := i.(*catalog.Component); ok {
		return RollupComponent(c)
	}
	if m, ok := i.(*catalog.Metric); ok {
		return []*catalog.Metric{m}
	}
	return nil
}

func RollupFeature(f *catalog.Feature) []*catalog.Metric {
	metrics := []*catalog.Metric{}

	for _, child := range f.Children {
		metrics = append(metrics, RollupFeature(child)...)
	}

	for _, metric := range f.Metrics {
		if metric.FeatureRollup {
			metrics = append(metrics, metric)
		}
	}
	return metrics
}

func RollupService(s *catalog.Service) []*catalog.Metric {
	metrics := []*catalog.Metric{}
	for _, component := range s.Components {
		if component.Rollup {
			metrics = append(metrics, RollupComponent(component)...)
		}
	}
	return metrics
}

func RollupComponent(c *catalog.Component) []*catalog.Metric {
	metrics := []*catalog.Metric{}
	for _, m := range c.Metrics {
		if m.ComponentRollup {
			metrics = append(metrics, m)
		}
	}
	return metrics
}
