package datamanager

import (
	"time"
)

type UpdateJob struct {
	date        time.Time
	dataManager DataManager
}

type Updater struct {
	jobs chan UpdateJob
}

var updater *Updater

func worker(u *Updater) {
	for {
		select {
		case j := <-u.jobs:
			j.dataManager.UpdateDataDay(j.date)
		}
	}
}

func GetUpdater() *Updater {
	if updater == nil {
		updater = &Updater{
			jobs: make(chan UpdateJob, 100000),
		}
		for w := 0; w < 8; w++ {
			go worker(updater)
		}
	}
	return updater
}

func AddUpdateJob(date time.Time, dataManager DataManager, async bool) {
	if async {
		updater = GetUpdater()
		updater.jobs <- UpdateJob{date: date, dataManager: dataManager}
	} else {
		dataManager.UpdateDataDay(date)
	}

}

type MultipleUpdateJob struct {
	days        int
	dataManager DataManager
}

type MultipleUpdater struct {
	jobs chan MultipleUpdateJob
}

var multiUpdater *MultipleUpdater

func multiworker(u *MultipleUpdater) {
	for {
		select {
		case j := <-u.jobs:
			j.dataManager.UpdateDataDays(j.days)
		}
	}
}

func GetMultipleUpdater() *MultipleUpdater {
	if multiUpdater == nil {
		multiUpdater = &MultipleUpdater{
			jobs: make(chan MultipleUpdateJob, 100000),
		}
		for w := 0; w < 8; w++ {
			go multiworker(multiUpdater)
		}
	}
	return multiUpdater
}

func AddMultipleUpdateJob(days int, dataManager DataManager, async bool) {
	if async {
		multiUpdater = GetMultipleUpdater()
		multiUpdater.jobs <- MultipleUpdateJob{days: days, dataManager: dataManager}
	} else {
		dataManager.UpdateDataDays(days)
	}

}
