package datasource

import (
	"time"

	"code.justin.tv/availability/hms-esk/pkg/daydata"
	"github.com/jinzhu/now"
)

// MockDataSource is a mock data source, returning fake data for
// any day queried.
type MockDataSource struct {
	metricID uint
	url      string
}

func NewMockDataSource(metricID uint, url string) DataSource {
	return &MockDataSource{
		metricID: metricID,
		url:      url,
	}
}

func (m *MockDataSource) Type() string {
	return "Mock"
}

func (m *MockDataSource) URL() string {
	return m.url
}

func (m *MockDataSource) DayData(date time.Time) daydata.DayData {
	return daydata.NewMockDayData(m.metricID, m.url, date)
}
func (m *MockDataSource) DaysData(numDays int) map[time.Time]daydata.DayData {
	end := now.BeginningOfDay()
	start := end.Add(time.Duration(-24*numDays) * time.Hour)
	days := map[time.Time]daydata.DayData{}
	for cur := start; !cur.After(end); cur = cur.Add(time.Duration(24) * time.Hour) {

		days[cur] = daydata.NewMockDayData(m.metricID, m.url, cur)

	}

	return days

}
