package datasource

import (
	"time"

	"code.justin.tv/availability/hms-esk/pkg/daydata"
	"github.com/jinzhu/now"
)

// NilDatasource is a data source that returns no data
type NilDatasource struct {
	metricID uint
	url      string
}

// NewNilDataSource creates a nil data source
func NewNilDataSource(metricID uint, url string) DataSource {
	return &NilDatasource{
		metricID: metricID,
		url:      url,
	}
}

// Type returns the datasource type
func (n *NilDatasource) Type() string {
	return "Nil"
}

// URL returns the URL associated with the data source
func (n *NilDatasource) URL() string {
	return n.url
}

func (n *NilDatasource) DayData(date time.Time) daydata.DayData {
	return nil
}

func (g *NilDatasource) DaysData(numDays int) map[time.Time]daydata.DayData {
	end := now.BeginningOfDay()
	start := end.Add(time.Duration(-24*numDays) * time.Hour)
	days := map[time.Time]daydata.DayData{}
	for cur := start; !cur.After(end); cur = cur.Add(time.Duration(24) * time.Hour) {

		days[cur] = nil

	}

	return days
}
