package daydata

import (
	"math/rand"
	"time"
)

// NewMockDayData instantiates a MetricDataDay with mock data for the
// specified day.
func NewMockDayData(metricID uint, url string, date time.Time) DayData {
	// Round to the beginning of the day

	midnight, _ := time.Parse("2006-01-02", date.Format("2006-01-02"))

	rawData := NewRawData("MockRaw", "mock data", "", "")
	rawDataList := []*RawData{rawData}
	availabilityData := []AvailabilityDatum{}

	for i := 1; i <= 24*12; i++ {
		value := rand.Float64() * 100.0
		availabilityData = append(availabilityData, AvailabilityDatum{
			Time:      midnight.Add(time.Duration(i*300) * time.Second),
			Available: value < 95.0,
		})
		rawData.Datapoints = append(rawData.Datapoints, FloatDatum{
			Time:  midnight.Add(time.Duration(i*300) * time.Second),
			Value: value,
		})
	}

	return NewDayData(metricID, url, midnight, availabilityData, rawDataList, false)
}
