#!/bin/bash

set -e

ACCOUNT=$1

case "$ACCOUNT" in
        production)
            ENVIRONMENTS=(production)
            ;;
        development)
            ENVIRONMENTS=(development)
            ;;
        *)
            echo "Unknown account \"$ACCOUNT\", exiting"
            exit 1
esac

for ENVIRONMENT in "${ENVIRONMENTS[@]}"
do
    ROLE=`terraform output -state=./terraform/${ACCOUNT}/.terraform/terraform.tfstate ${ENVIRONMENT}-iam_role_arn`

    tcs sandstorm role-flags \
        --owner team-syseng \
        --name syseng-${ENVIRONMENT}-hms-esk \
        --secret_key "syseng/hms-esk/${ENVIRONMENT}/*" \
        --allowed_arn "${ROLE}" \
        --output ./sandstorm.d/${ACCOUNT}_${ENVIRONMENT}.json

done
