

module "bs-development" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-dev"
  eb_application_name = "${module.bs-app-development.beanstalk_application_name}"
  vpc_id = "vpc-a19ca9c5"
  ec2_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  elb_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  elb_loadbalancer_security_groups = "sg-e55f4f83"
  auto_scaling_lc_security_groups = "sg-e55f4f83"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "availability@twitch.tv"
  service = "availability/hms-esk"
  env = "development"
  associate_public_address = "false"
  cname_prefix = "hms-esk-development"

}
