import os

prod_catalog = "https://status.internal.justin.tv/api/v1"
staging_catalog = "https://status-development.internal.justin.tv/api/v1"
prod_catalog_gql = "https://status.internal.justin.tv/api/v2/query.s2s"
staging_catalog_gql = "https://status-development.internal.justin.tv/api/v2/query.s2s"


# Returns the service catalog endpoint
# based on the environment
def get_catalog_endpoint():
    try:
        env = os.environ["environment"]
        if env == "production":
            endpoint = prod_catalog
        elif env == "staging":
            endpoint = staging_catalog
        else:
            raise NameError("no such environment '{env}'".format(env=env))
    except KeyError:
        endpoint = get_catalog_endpoint_from_env_vars()
    return endpoint


def get_catalog_endpoint_from_env_vars():
    # Get required params
    try:
        endpoint = os.environ['CATALOG_ENDPOINT']
    except KeyError:
        # Custom error message
        raise NameError("must define either a valid 'environment' or 'CATALOG_ENDPOINT'")

    return endpoint

# Returns the service catalog endpoint
# based on the environment
def get_catalog_gql_endpoint():
    try:
        env = os.environ["environment"]
        if env == "production":
            endpoint = prod_catalog_gql
        elif env == "staging":
            endpoint = staging_catalog_gql
        else:
            raise NameError("no such environment '{env}'".format(env=env))
    except KeyError:
        endpoint = get_catalog_gql_endpoint_from_env_vars()
    return endpoint

def get_catalog_gql_endpoint_from_env_vars():
    # Get required params
    try:
        endpoint = os.environ['CATALOG_ENDPOINT_GQL']
    except KeyError:
        # Custom error message
        raise NameError("must define either a valid 'environment' or 'CATALOG_ENDPOINT'")

    return endpoint
