import os
from twitch import sandstorm

user_cred_template = "syseng/inv-collector/{e}/redshift_user"
password_cred_template = "syseng/inv-collector/{e}/redshift_password"


# returns a username and password of a redshift database,
# switched on the environment
# returns None if no 'environment' env-var is defined
def get_redshift_creds():
    role, env = get_iam_role()

    # If no 'environment' is set, try to retrieve hardcoded creds
    if role is None:
        return get_creds_from_environment()

    # Use sandstorm to get the creds
    client = client = sandstorm.SandstormClient(role)
    user = client.GetSecret(user_cred_template.format(e=env))
    password = client.GetSecret(password_cred_template.format(e=env))

    return user, password


# Returns the IAM role to assume for sandstorm access,
# or none if the 'environment' variable isn't set
# Also returns the 'environment' setting
def get_iam_role():
    try:
        env = os.environ['environment']
    except KeyError:
        return (None, None)

    if env == "production":
        role = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/inv-collector-production"
    elif env == "staging":
        role = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/inv-collector-staging"
    else:
        raise NameError("no such environment '{env}'".format(env=env))

    return role, env


# Look up REDSHIFT_USER and REDSHIFT_PASSWORD in the environment
# returns a touple containing the two
# or returns None if the env-vars do not exist
def get_creds_from_environment():
    try:
        user = os.environ['REDSHIFT_USER']
        password = os.environ['REDSHIFT_PASSWORD']
    except KeyError:
        return (None, None)
    return user, password
