job {
  name 'availability-inv-collector-create'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'availability/inv-collector', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  steps {
    shell "rm -rf .manta/"
    shell "manta -v"
    saveLambdaFunction "availability/inv-collector", ".manta"
  }
}

job {
  name 'availability-inv-collector-prod-deploy'
  using 'TEMPLATE-lambda-deploy'
  steps {
    deployLambdaFunction "availability/inv-collector", "availability-inv-collector-\$ENVIRONMENT", "\$ENVIRONMENT"
  }
    wrappers {
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'aws_config')
      file('AWS_UPLOADER_CONFIG_FILE', 'twitch-central-aws-lambda-deploy')
    }
  }
}

job {
  name 'availability-inv-collector-staging-deploy'
  using 'TEMPLATE-lambda-deploy'
  steps {
    deployLambdaFunction "availability/inv-collector", "availability-inv-collector-\$ENVIRONMENT", "\$ENVIRONMENT"
  }
    wrappers {
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'aws_config')
      file('AWS_UPLOADER_CONFIG_FILE', 'twitch-central-dev-lambda-deploy')
    }
  }
}

