
module "tf_lambda_app" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_lambda_app.git?ref=1.6.0"
  aws_region = "${var.aws_region}"
  aws_profile = "twitch-central-aws"
  owner = "availability-team@twitch.tv"
  repository = "availability/inv-collector"
  environment = "production"
  lambda_handler = "run.lambda_handler"
  lambda_function_name = "availability-inv-collector-production"
  lambda_timeout = "120"
  lambda_description = "This lambda acts as a bridge between inventory management's redshift and the service catalog. It adds new components to the service catalog."
  lambda_runtime = "python2.7"
  
  principal = "007917851548"
  lambda_vpc_subnet_ids = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  lambda_vpc_security_group_ids = "sg-1825527e"
}
