
module "tf_lambda_app" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_lambda_app.git?ref=1.6.0"
  aws_region = "${var.aws_region}"
  aws_profile = "twitch-central-dev"
  owner = "availability-team@twitch.tv"
  repository = "availability/inv-collector"
  environment = "staging"
  lambda_handler = "run.lambda_handler"
  lambda_function_name = "availability-inv-collector-staging"
  lambda_timeout = "120"
  lambda_description = "A python lambda app"
  lambda_runtime = "python2.7"
  
  principal = "386434559102"
  lambda_vpc_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  lambda_vpc_security_group_ids = "sg-e55f4f83"
}
