package handler

import (
	"github.com/prometheus/prometheus/prompb"

	"code.justin.tv/availability/necrophos/metrics"
)

type QueryHandler struct {
	Query       *prompb.Query
	queryResult *prompb.QueryResult
	queryErr    error
	done        chan bool
}

func NewQueryHandler(query *prompb.Query) *QueryHandler {
	return &QueryHandler{
		Query: query,
		done:  make(chan bool, 1),
	}
}

func (qh *QueryHandler) Execute() {
	queryResult, err := metrics.GetCloudwatchData(qh.Query)
	if err != nil {
		qh.queryErr = err
	} else {
		qh.queryResult = queryResult
	}
	qh.done <- true
}

// When called, will wait on the execution phase of the QueryHandler to finish.
// This method should only be called ONCE, and after Execute() is called
// This function makes it easy to run many queries in parallel to speed up
// overall request execution
func (qh *QueryHandler) GetQueryResults() (*prompb.QueryResult, error) {
	// Wait until execution is finished
	<-qh.done
	// Hand back the results
	return qh.queryResult, qh.queryErr

}
