package metrics

import (
	"github.com/golang/protobuf/proto"
	"github.com/golang/snappy"
	"github.com/prometheus/prometheus/prompb"
)

// func to decode an HTTP body into a prometheus ReadRequest
func DecodePrometheusReadRequest(rr []byte) (*prompb.ReadRequest, error) {
	// Use snappy to decode/uncompress the request into a buffer
	reqBuf, err := snappy.Decode(nil, rr)
	if err != nil {
		return nil, err
	}

	// Use protobuf to unmarshal the request into a prometheus protobuf ReadRequest
	var req prompb.ReadRequest
	if err := proto.Unmarshal(reqBuf, &req); err != nil {
		return nil, err
	}
	return &req, nil
}

// func to convert a slice of Cloudwatch GetMetricStatistic
// responses into a Prometheus ReadResponse

// func to convert a Prometheus ReadResponse into an encoded
// byte stream
func EncodePrometheusReadResponse(rr *prompb.ReadResponse) ([]byte, error) {
	data, err := proto.Marshal(rr)
	if err != nil {
		return nil, err
	}
	// now snappy encode it
	compressedData := snappy.Encode(nil, data)
	return compressedData, nil

}

// func to decode Prometheus WriteRequest
func DecodePrometheusWriteRequest(wr []byte) (*prompb.WriteRequest, error) {
	// Use snappy to decode/uncompress the request into a buffer
	reqBuf, err := snappy.Decode(nil, wr)
	if err != nil {
		return nil, err
	}

	// Use protobuf to unmarshal the request into a prometheus protobuf ReadRequest
	var req prompb.WriteRequest
	if err := proto.Unmarshal(reqBuf, &req); err != nil {
		return nil, err
	}
	return &req, nil
}
