#!/bin/bash

set -e

ACCOUNT=$1

case "$ACCOUNT" in
        production)
            ENVIRONMENTS=(production)
            ;;
        staging)
            ENVIRONMENTS=(staging)
            ;;
        development)
            ENVIRONMENTS=(development)
            ;;
        *)
            echo "Unknown account \"$ACCOUNT\", exiting"
            exit 1
esac

cd ./terraform/${ACCOUNT}

for ENVIRONMENT in "${ENVIRONMENTS[@]}"
do
    ROLE=`terraform output ${ENVIRONMENT}-iam_role_arn`

    tcs sandstorm role-flags \
        --owner team-syseng \
        --name syseng-${ENVIRONMENT}-necrophos \
        --secret_key "syseng/necrophos/${ENVIRONMENT}/*" \
        --allowed_arn "${ROLE}" \
        --output ./sandstorm.d/${ACCOUNT}_${ENVIRONMENT}.json

done
