

module "bs-staging" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-dev"
  aws_region = "us-west-2"
  eb_application_name = "${module.bs-app-staging.beanstalk_application_name}"
  vpc_id = "vpc-a19ca9c5"
  ec2_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  elb_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  elb_loadbalancer_security_groups = "sg-e55f4f83"
  auto_scaling_lc_security_groups = "sg-e55f4f83"
  solution_stack_name = "64bit Amazon Linux 2017.03 v2.7.1 running Docker 17.03.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "availability@twitch.tv"
  service = "availability/necrophos"
  env = "staging"
  associate_public_address = "false"
  cname_prefix = "necrophos-staging"

}
