// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/cloudtrace/v1/trace.proto

/*
Package cloudtrace is a generated protocol buffer package.

It is generated from these files:
	google/devtools/cloudtrace/v1/trace.proto

It has these top-level messages:
	Trace
	Traces
	TraceSpan
	ListTracesRequest
	ListTracesResponse
	GetTraceRequest
	PatchTracesRequest
*/
package cloudtrace

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Type of span. Can be used to specify additional relationships between spans
// in addition to a parent/child relationship.
type TraceSpan_SpanKind int32

const (
	// Unspecified.
	TraceSpan_SPAN_KIND_UNSPECIFIED TraceSpan_SpanKind = 0
	// Indicates that the span covers server-side handling of an RPC or other
	// remote network request.
	TraceSpan_RPC_SERVER TraceSpan_SpanKind = 1
	// Indicates that the span covers the client-side wrapper around an RPC or
	// other remote request.
	TraceSpan_RPC_CLIENT TraceSpan_SpanKind = 2
)

var TraceSpan_SpanKind_name = map[int32]string{
	0: "SPAN_KIND_UNSPECIFIED",
	1: "RPC_SERVER",
	2: "RPC_CLIENT",
}
var TraceSpan_SpanKind_value = map[string]int32{
	"SPAN_KIND_UNSPECIFIED": 0,
	"RPC_SERVER":            1,
	"RPC_CLIENT":            2,
}

func (x TraceSpan_SpanKind) String() string {
	return proto.EnumName(TraceSpan_SpanKind_name, int32(x))
}
func (TraceSpan_SpanKind) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

// Type of data returned for traces in the list.
type ListTracesRequest_ViewType int32

const (
	// Default is `MINIMAL` if unspecified.
	ListTracesRequest_VIEW_TYPE_UNSPECIFIED ListTracesRequest_ViewType = 0
	// Minimal view of the trace record that contains only the project
	// and trace IDs.
	ListTracesRequest_MINIMAL ListTracesRequest_ViewType = 1
	// Root span view of the trace record that returns the root spans along
	// with the minimal trace data.
	ListTracesRequest_ROOTSPAN ListTracesRequest_ViewType = 2
	// Complete view of the trace record that contains the actual trace data.
	// This is equivalent to calling the REST `get` or RPC `GetTrace` method
	// using the ID of each listed trace.
	ListTracesRequest_COMPLETE ListTracesRequest_ViewType = 3
)

var ListTracesRequest_ViewType_name = map[int32]string{
	0: "VIEW_TYPE_UNSPECIFIED",
	1: "MINIMAL",
	2: "ROOTSPAN",
	3: "COMPLETE",
}
var ListTracesRequest_ViewType_value = map[string]int32{
	"VIEW_TYPE_UNSPECIFIED": 0,
	"MINIMAL":               1,
	"ROOTSPAN":              2,
	"COMPLETE":              3,
}

func (x ListTracesRequest_ViewType) String() string {
	return proto.EnumName(ListTracesRequest_ViewType_name, int32(x))
}
func (ListTracesRequest_ViewType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{3, 0}
}

// A trace describes how long it takes for an application to perform an
// operation. It consists of a set of spans, each of which represent a single
// timed event within the operation.
type Trace struct {
	// Project ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Globally unique identifier for the trace. This identifier is a 128-bit
	// numeric value formatted as a 32-byte hex string.
	TraceId string `protobuf:"bytes,2,opt,name=trace_id,json=traceId" json:"trace_id,omitempty"`
	// Collection of spans in the trace.
	Spans []*TraceSpan `protobuf:"bytes,3,rep,name=spans" json:"spans,omitempty"`
}

func (m *Trace) Reset()                    { *m = Trace{} }
func (m *Trace) String() string            { return proto.CompactTextString(m) }
func (*Trace) ProtoMessage()               {}
func (*Trace) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Trace) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Trace) GetTraceId() string {
	if m != nil {
		return m.TraceId
	}
	return ""
}

func (m *Trace) GetSpans() []*TraceSpan {
	if m != nil {
		return m.Spans
	}
	return nil
}

// List of new or updated traces.
type Traces struct {
	// List of traces.
	Traces []*Trace `protobuf:"bytes,1,rep,name=traces" json:"traces,omitempty"`
}

func (m *Traces) Reset()                    { *m = Traces{} }
func (m *Traces) String() string            { return proto.CompactTextString(m) }
func (*Traces) ProtoMessage()               {}
func (*Traces) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Traces) GetTraces() []*Trace {
	if m != nil {
		return m.Traces
	}
	return nil
}

// A span represents a single timed event within a trace. Spans can be nested
// and form a trace tree. Often, a trace contains a root span that describes the
// end-to-end latency of an operation and, optionally, one or more subspans for
// its suboperations. Spans do not need to be contiguous. There may be gaps
// between spans in a trace.
type TraceSpan struct {
	// Identifier for the span. Must be a 64-bit integer other than 0 and
	// unique within a trace.
	SpanId uint64 `protobuf:"fixed64,1,opt,name=span_id,json=spanId" json:"span_id,omitempty"`
	// Distinguishes between spans generated in a particular context. For example,
	// two spans with the same name may be distinguished using `RPC_CLIENT`
	// and `RPC_SERVER` to identify queueing latency associated with the span.
	Kind TraceSpan_SpanKind `protobuf:"varint,2,opt,name=kind,enum=google.devtools.cloudtrace.v1.TraceSpan_SpanKind" json:"kind,omitempty"`
	// Name of the trace. The trace name is sanitized and displayed in the
	// Stackdriver Trace tool in the Google Developers Console.
	// The name may be a method name or some other per-call site name.
	// For the same executable and the same call point, a best practice is
	// to use a consistent name, which makes it easier to correlate
	// cross-trace spans.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// Start time of the span in nanoseconds from the UNIX epoch.
	StartTime *google_protobuf2.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// End time of the span in nanoseconds from the UNIX epoch.
	EndTime *google_protobuf2.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// ID of the parent span, if any. Optional.
	ParentSpanId uint64 `protobuf:"fixed64,6,opt,name=parent_span_id,json=parentSpanId" json:"parent_span_id,omitempty"`
	// Collection of labels associated with the span.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *TraceSpan) Reset()                    { *m = TraceSpan{} }
func (m *TraceSpan) String() string            { return proto.CompactTextString(m) }
func (*TraceSpan) ProtoMessage()               {}
func (*TraceSpan) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *TraceSpan) GetSpanId() uint64 {
	if m != nil {
		return m.SpanId
	}
	return 0
}

func (m *TraceSpan) GetKind() TraceSpan_SpanKind {
	if m != nil {
		return m.Kind
	}
	return TraceSpan_SPAN_KIND_UNSPECIFIED
}

func (m *TraceSpan) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TraceSpan) GetStartTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TraceSpan) GetEndTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *TraceSpan) GetParentSpanId() uint64 {
	if m != nil {
		return m.ParentSpanId
	}
	return 0
}

func (m *TraceSpan) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// The request message for the `ListTraces` method. All fields are required
// unless specified.
type ListTracesRequest struct {
	// ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Type of data returned for traces in the list. Optional. Default is
	// `MINIMAL`.
	View ListTracesRequest_ViewType `protobuf:"varint,2,opt,name=view,enum=google.devtools.cloudtrace.v1.ListTracesRequest_ViewType" json:"view,omitempty"`
	// Maximum number of traces to return. If not specified or <= 0, the
	// implementation selects a reasonable value.  The implementation may
	// return fewer traces than the requested page size. Optional.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token identifying the page of results to return. If provided, use the
	// value of the `next_page_token` field from a previous request. Optional.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// End of the time interval (inclusive) during which the trace data was
	// collected from the application.
	StartTime *google_protobuf2.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Start of the time interval (inclusive) during which the trace data was
	// collected from the application.
	EndTime *google_protobuf2.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// An optional filter for the request.
	Filter string `protobuf:"bytes,7,opt,name=filter" json:"filter,omitempty"`
	// Field used to sort the returned traces. Optional.
	// Can be one of the following:
	//
	// *   `trace_id`
	// *   `name` (`name` field of root span in the trace)
	// *   `duration` (difference between `end_time` and `start_time` fields of
	//      the root span)
	// *   `start` (`start_time` field of the root span)
	//
	// Descending order can be specified by appending `desc` to the sort field
	// (for example, `name desc`).
	//
	// Only one sort field is permitted.
	OrderBy string `protobuf:"bytes,8,opt,name=order_by,json=orderBy" json:"order_by,omitempty"`
}

func (m *ListTracesRequest) Reset()                    { *m = ListTracesRequest{} }
func (m *ListTracesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTracesRequest) ProtoMessage()               {}
func (*ListTracesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListTracesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListTracesRequest) GetView() ListTracesRequest_ViewType {
	if m != nil {
		return m.View
	}
	return ListTracesRequest_VIEW_TYPE_UNSPECIFIED
}

func (m *ListTracesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTracesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTracesRequest) GetStartTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ListTracesRequest) GetEndTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *ListTracesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListTracesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// The response message for the `ListTraces` method.
type ListTracesResponse struct {
	// List of trace records returned.
	Traces []*Trace `protobuf:"bytes,1,rep,name=traces" json:"traces,omitempty"`
	// If defined, indicates that there are more traces that match the request
	// and that this value should be passed to the next request to continue
	// retrieving additional traces.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTracesResponse) Reset()                    { *m = ListTracesResponse{} }
func (m *ListTracesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTracesResponse) ProtoMessage()               {}
func (*ListTracesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ListTracesResponse) GetTraces() []*Trace {
	if m != nil {
		return m.Traces
	}
	return nil
}

func (m *ListTracesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for the `GetTrace` method.
type GetTraceRequest struct {
	// ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// ID of the trace to return.
	TraceId string `protobuf:"bytes,2,opt,name=trace_id,json=traceId" json:"trace_id,omitempty"`
}

func (m *GetTraceRequest) Reset()                    { *m = GetTraceRequest{} }
func (m *GetTraceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTraceRequest) ProtoMessage()               {}
func (*GetTraceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *GetTraceRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetTraceRequest) GetTraceId() string {
	if m != nil {
		return m.TraceId
	}
	return ""
}

// The request message for the `PatchTraces` method.
type PatchTracesRequest struct {
	// ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The body of the message.
	Traces *Traces `protobuf:"bytes,2,opt,name=traces" json:"traces,omitempty"`
}

func (m *PatchTracesRequest) Reset()                    { *m = PatchTracesRequest{} }
func (m *PatchTracesRequest) String() string            { return proto.CompactTextString(m) }
func (*PatchTracesRequest) ProtoMessage()               {}
func (*PatchTracesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *PatchTracesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *PatchTracesRequest) GetTraces() *Traces {
	if m != nil {
		return m.Traces
	}
	return nil
}

func init() {
	proto.RegisterType((*Trace)(nil), "google.devtools.cloudtrace.v1.Trace")
	proto.RegisterType((*Traces)(nil), "google.devtools.cloudtrace.v1.Traces")
	proto.RegisterType((*TraceSpan)(nil), "google.devtools.cloudtrace.v1.TraceSpan")
	proto.RegisterType((*ListTracesRequest)(nil), "google.devtools.cloudtrace.v1.ListTracesRequest")
	proto.RegisterType((*ListTracesResponse)(nil), "google.devtools.cloudtrace.v1.ListTracesResponse")
	proto.RegisterType((*GetTraceRequest)(nil), "google.devtools.cloudtrace.v1.GetTraceRequest")
	proto.RegisterType((*PatchTracesRequest)(nil), "google.devtools.cloudtrace.v1.PatchTracesRequest")
	proto.RegisterEnum("google.devtools.cloudtrace.v1.TraceSpan_SpanKind", TraceSpan_SpanKind_name, TraceSpan_SpanKind_value)
	proto.RegisterEnum("google.devtools.cloudtrace.v1.ListTracesRequest_ViewType", ListTracesRequest_ViewType_name, ListTracesRequest_ViewType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for TraceService service

type TraceServiceClient interface {
	// Returns of a list of traces that match the specified filter conditions.
	ListTraces(ctx context.Context, in *ListTracesRequest, opts ...grpc.CallOption) (*ListTracesResponse, error)
	// Gets a single trace by its ID.
	GetTrace(ctx context.Context, in *GetTraceRequest, opts ...grpc.CallOption) (*Trace, error)
	// Sends new traces to Stackdriver Trace or updates existing traces. If the ID
	// of a trace that you send matches that of an existing trace, any fields
	// in the existing trace and its spans are overwritten by the provided values,
	// and any new fields provided are merged with the existing trace data. If the
	// ID does not match, a new trace is created.
	PatchTraces(ctx context.Context, in *PatchTracesRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
}

type traceServiceClient struct {
	cc *grpc.ClientConn
}

func NewTraceServiceClient(cc *grpc.ClientConn) TraceServiceClient {
	return &traceServiceClient{cc}
}

func (c *traceServiceClient) ListTraces(ctx context.Context, in *ListTracesRequest, opts ...grpc.CallOption) (*ListTracesResponse, error) {
	out := new(ListTracesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.cloudtrace.v1.TraceService/ListTraces", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *traceServiceClient) GetTrace(ctx context.Context, in *GetTraceRequest, opts ...grpc.CallOption) (*Trace, error) {
	out := new(Trace)
	err := grpc.Invoke(ctx, "/google.devtools.cloudtrace.v1.TraceService/GetTrace", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *traceServiceClient) PatchTraces(ctx context.Context, in *PatchTracesRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.cloudtrace.v1.TraceService/PatchTraces", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for TraceService service

type TraceServiceServer interface {
	// Returns of a list of traces that match the specified filter conditions.
	ListTraces(context.Context, *ListTracesRequest) (*ListTracesResponse, error)
	// Gets a single trace by its ID.
	GetTrace(context.Context, *GetTraceRequest) (*Trace, error)
	// Sends new traces to Stackdriver Trace or updates existing traces. If the ID
	// of a trace that you send matches that of an existing trace, any fields
	// in the existing trace and its spans are overwritten by the provided values,
	// and any new fields provided are merged with the existing trace data. If the
	// ID does not match, a new trace is created.
	PatchTraces(context.Context, *PatchTracesRequest) (*google_protobuf1.Empty, error)
}

func RegisterTraceServiceServer(s *grpc.Server, srv TraceServiceServer) {
	s.RegisterService(&_TraceService_serviceDesc, srv)
}

func _TraceService_ListTraces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTracesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TraceServiceServer).ListTraces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudtrace.v1.TraceService/ListTraces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TraceServiceServer).ListTraces(ctx, req.(*ListTracesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TraceService_GetTrace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTraceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TraceServiceServer).GetTrace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudtrace.v1.TraceService/GetTrace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TraceServiceServer).GetTrace(ctx, req.(*GetTraceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TraceService_PatchTraces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchTracesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TraceServiceServer).PatchTraces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudtrace.v1.TraceService/PatchTraces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TraceServiceServer).PatchTraces(ctx, req.(*PatchTracesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TraceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.cloudtrace.v1.TraceService",
	HandlerType: (*TraceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTraces",
			Handler:    _TraceService_ListTraces_Handler,
		},
		{
			MethodName: "GetTrace",
			Handler:    _TraceService_GetTrace_Handler,
		},
		{
			MethodName: "PatchTraces",
			Handler:    _TraceService_PatchTraces_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/cloudtrace/v1/trace.proto",
}

func init() { proto.RegisterFile("google/devtools/cloudtrace/v1/trace.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 886 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0x66, 0xed, 0x78, 0x6d, 0x1f, 0x87, 0xd4, 0x8c, 0x68, 0x71, 0x5d, 0x2a, 0xc2, 0xaa, 0x20,
	0x03, 0x62, 0xb7, 0x76, 0x41, 0x22, 0xe5, 0x47, 0x6a, 0xdc, 0x6d, 0xb4, 0x8a, 0xe3, 0xac, 0xd6,
	0x26, 0x08, 0x6e, 0x56, 0x13, 0xef, 0xd4, 0x2c, 0x59, 0xcf, 0x2c, 0x3b, 0x13, 0x17, 0xa7, 0xea,
	0x05, 0x5c, 0x72, 0x09, 0xe2, 0x8a, 0x37, 0xe0, 0x92, 0x37, 0x41, 0xbc, 0x02, 0x12, 0xaf, 0x81,
	0x66, 0x66, 0xb7, 0x89, 0x12, 0x35, 0x76, 0xe8, 0x4d, 0x34, 0xe7, 0xcc, 0xf9, 0xfd, 0xbe, 0x6f,
	0xb2, 0x86, 0xf7, 0xa6, 0x8c, 0x4d, 0x13, 0xe2, 0x44, 0x64, 0x2e, 0x18, 0x4b, 0xb8, 0x33, 0x49,
	0xd8, 0x71, 0x24, 0x32, 0x3c, 0x21, 0xce, 0xbc, 0xeb, 0xa8, 0x83, 0x9d, 0x66, 0x4c, 0x30, 0x74,
	0x5b, 0x87, 0xda, 0x45, 0xa8, 0x7d, 0x1a, 0x6a, 0xcf, 0xbb, 0xed, 0x37, 0xf3, 0x4a, 0x38, 0x8d,
	0x1d, 0x4c, 0x29, 0x13, 0x58, 0xc4, 0x8c, 0x72, 0x9d, 0xdc, 0xbe, 0x95, 0xdf, 0x2a, 0xeb, 0xf0,
	0xf8, 0xb1, 0x43, 0x66, 0xa9, 0x58, 0xe4, 0x97, 0x6f, 0x9d, 0xbf, 0x14, 0xf1, 0x8c, 0x70, 0x81,
	0x67, 0xa9, 0x0e, 0xb0, 0x7e, 0x34, 0xa0, 0x32, 0x96, 0x8d, 0xd0, 0x6d, 0x80, 0x34, 0x63, 0xdf,
	0x91, 0x89, 0x08, 0xe3, 0xa8, 0x65, 0x6c, 0x1a, 0x9d, 0x7a, 0x50, 0xcf, 0x3d, 0x5e, 0x84, 0x6e,
	0x42, 0x4d, 0x0d, 0x24, 0x2f, 0x4b, 0xea, 0xb2, 0xaa, 0x6c, 0x2f, 0x42, 0x5f, 0x40, 0x85, 0xa7,
	0x98, 0xf2, 0x56, 0x79, 0xb3, 0xdc, 0x69, 0xf4, 0x3a, 0xf6, 0xa5, 0xeb, 0xd8, 0xaa, 0xdd, 0x28,
	0xc5, 0x34, 0xd0, 0x69, 0xd6, 0x23, 0x30, 0x95, 0x8f, 0xa3, 0xcf, 0xc0, 0x54, 0x61, 0xbc, 0x65,
	0xa8, 0x52, 0x77, 0x56, 0x29, 0x15, 0xe4, 0x39, 0xd6, 0xbf, 0x65, 0xa8, 0x3f, 0x2f, 0x8e, 0xde,
	0x80, 0xaa, 0x2c, 0x5f, 0x2c, 0x63, 0x06, 0xa6, 0x34, 0xbd, 0x08, 0xb9, 0xb0, 0x76, 0x14, 0x53,
	0xbd, 0xc5, 0x46, 0xaf, 0xbb, 0xea, 0xb4, 0xb6, 0xfc, 0xb3, 0x1b, 0xd3, 0x28, 0x50, 0xe9, 0x08,
	0xc1, 0x1a, 0xc5, 0x33, 0xd2, 0x2a, 0x2b, 0x30, 0xd4, 0x19, 0x6d, 0x01, 0x70, 0x81, 0x33, 0x11,
	0x4a, 0x98, 0x5b, 0x6b, 0x9b, 0x46, 0xa7, 0xd1, 0x6b, 0x17, 0x0d, 0x0a, 0x0e, 0xec, 0x71, 0xc1,
	0x41, 0x50, 0x57, 0xd1, 0xd2, 0x46, 0x1f, 0x43, 0x8d, 0xd0, 0x48, 0x27, 0x56, 0x96, 0x26, 0x56,
	0x09, 0x8d, 0x54, 0xda, 0x1d, 0xd8, 0x48, 0x71, 0x46, 0xa8, 0x08, 0x8b, 0x65, 0x4d, 0xb5, 0xec,
	0xba, 0xf6, 0x8e, 0xf4, 0xca, 0x03, 0x30, 0x13, 0x7c, 0x48, 0x12, 0xde, 0xaa, 0x2a, 0x5c, 0x3f,
	0x5a, 0x79, 0xe9, 0x81, 0x4a, 0x73, 0xa9, 0xc8, 0x16, 0x41, 0x5e, 0xa3, 0xbd, 0x05, 0x8d, 0x33,
	0x6e, 0xd4, 0x84, 0xf2, 0x11, 0x59, 0xe4, 0x8a, 0x91, 0x47, 0xf4, 0x3a, 0x54, 0xe6, 0x38, 0x39,
	0x26, 0xb9, 0x50, 0xb4, 0x71, 0xbf, 0xf4, 0x89, 0x61, 0xb9, 0x50, 0x2b, 0x60, 0x44, 0x37, 0xe1,
	0xfa, 0xc8, 0x7f, 0x30, 0x0c, 0x77, 0xbd, 0xe1, 0xc3, 0xf0, 0xcb, 0xe1, 0xc8, 0x77, 0xfb, 0xde,
	0x23, 0xcf, 0x7d, 0xd8, 0x7c, 0x05, 0x6d, 0x00, 0x04, 0x7e, 0x3f, 0x1c, 0xb9, 0xc1, 0x81, 0x1b,
	0x34, 0x8d, 0xc2, 0xee, 0x0f, 0x3c, 0x77, 0x38, 0x6e, 0x96, 0xac, 0x3f, 0xcb, 0xf0, 0xda, 0x20,
	0xe6, 0x42, 0xcb, 0x26, 0x20, 0xdf, 0x1f, 0x13, 0x2e, 0x96, 0x29, 0x78, 0x0f, 0xd6, 0xe6, 0x31,
	0x79, 0x92, 0xf3, 0xbe, 0xb5, 0x04, 0x82, 0x0b, 0xe5, 0xed, 0x83, 0x98, 0x3c, 0x19, 0x2f, 0x52,
	0x12, 0xa8, 0x32, 0xe8, 0x16, 0xd4, 0x53, 0x3c, 0x25, 0x21, 0x8f, 0x4f, 0xb4, 0x08, 0x2a, 0x41,
	0x4d, 0x3a, 0x46, 0xf1, 0x89, 0x7e, 0x4c, 0xf2, 0x52, 0xb0, 0x23, 0x42, 0x95, 0x10, 0xe4, 0x28,
	0x78, 0x4a, 0xc6, 0xd2, 0x71, 0x4e, 0x27, 0x95, 0xff, 0xab, 0x13, 0x73, 0x75, 0x9d, 0xdc, 0x00,
	0xf3, 0x71, 0x9c, 0x08, 0x92, 0xb5, 0xaa, 0x6a, 0x98, 0xdc, 0x92, 0xcf, 0x9a, 0x65, 0x11, 0xc9,
	0xc2, 0xc3, 0x45, 0xab, 0xa6, 0x9f, 0xb5, 0xb2, 0xb7, 0x17, 0xd6, 0x10, 0x6a, 0xc5, 0xca, 0x92,
	0xab, 0x03, 0xcf, 0xfd, 0x2a, 0x1c, 0x7f, 0xed, 0xbb, 0xe7, 0xb8, 0x6a, 0x40, 0x75, 0xcf, 0x1b,
	0x7a, 0x7b, 0x0f, 0x06, 0x4d, 0x03, 0xad, 0x43, 0x2d, 0xd8, 0xdf, 0x1f, 0x4b, 0x5e, 0x9b, 0x25,
	0x69, 0xf5, 0xf7, 0xf7, 0xfc, 0x81, 0x3b, 0x76, 0x9b, 0x65, 0xeb, 0x04, 0xd0, 0x59, 0x50, 0x79,
	0xca, 0x28, 0x27, 0x2f, 0xf7, 0xe4, 0xd1, 0xbb, 0x70, 0x8d, 0x92, 0x1f, 0x44, 0x78, 0x06, 0x6c,
	0xad, 0xb9, 0x57, 0xa5, 0xdb, 0x2f, 0x00, 0xb7, 0x76, 0xe1, 0xda, 0x0e, 0xd1, 0xad, 0x57, 0x54,
	0xcb, 0x8b, 0xff, 0xdf, 0x59, 0x19, 0x20, 0x1f, 0x8b, 0xc9, 0xb7, 0x57, 0x52, 0xdf, 0xe7, 0xcf,
	0xf7, 0x2c, 0x29, 0xd6, 0xde, 0x59, 0x65, 0x4f, 0x5e, 0x2c, 0xda, 0xfb, 0xab, 0x0c, 0xeb, 0xfa,
	0x55, 0x92, 0x6c, 0x1e, 0x4f, 0x08, 0xfa, 0xdd, 0x00, 0x38, 0x85, 0x13, 0xdd, 0xbd, 0xaa, 0x9c,
	0xdb, 0xdd, 0x2b, 0x64, 0x68, 0xae, 0xac, 0xce, 0x4f, 0x7f, 0xff, 0xf3, 0x6b, 0xc9, 0x42, 0x9b,
	0xf2, 0x03, 0x96, 0xaf, 0xc6, 0x9d, 0xa7, 0xa7, 0x6b, 0x3f, 0x73, 0x72, 0x5e, 0x7e, 0x33, 0xa0,
	0x56, 0x00, 0x8e, 0xec, 0x25, 0x9d, 0xce, 0x31, 0xd3, 0x5e, 0x49, 0x02, 0xd6, 0x3d, 0x35, 0xcc,
	0x87, 0xe8, 0x83, 0x65, 0xc3, 0x38, 0x4f, 0x0b, 0x22, 0x9f, 0xa1, 0x9f, 0x0d, 0x68, 0x9c, 0xe1,
	0x0e, 0x2d, 0x03, 0xe1, 0x22, 0xcf, 0xed, 0x1b, 0x17, 0x9e, 0x9b, 0x2b, 0x3f, 0xb8, 0xd6, 0x5d,
	0x35, 0xcf, 0xfb, 0xbd, 0xa5, 0xe0, 0xdc, 0xcf, 0x39, 0xdd, 0xfe, 0xc5, 0x80, 0xb7, 0x27, 0x6c,
	0x76, 0xf9, 0x08, 0xdb, 0xa0, 0xda, 0xfb, 0xb2, 0x99, 0x6f, 0x7c, 0xb3, 0x93, 0x07, 0x4f, 0x59,
	0x82, 0xe9, 0xd4, 0x66, 0xd9, 0xd4, 0x99, 0x12, 0xaa, 0x46, 0x71, 0xf4, 0x15, 0x4e, 0x63, 0xfe,
	0x82, 0x1f, 0x1d, 0x9f, 0x9e, 0x5a, 0x7f, 0x94, 0xae, 0xef, 0xe8, 0x4a, 0x7d, 0xe9, 0xd3, 0x98,
	0xda, 0x07, 0xdd, 0x43, 0x53, 0xd5, 0xba, 0xf7, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0c, 0xd5,
	0x26, 0xa6, 0xbf, 0x08, 0x00, 0x00,
}
