// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/logging/v2/logging_config.proto

package logging

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf5 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf6 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Available log entry formats. Log entries can be written to Stackdriver
// Logging in either format and can be exported in either format.
// Version 2 is the preferred format.
type LogSink_VersionFormat int32

const (
	// An unspecified format version that will default to V2.
	LogSink_VERSION_FORMAT_UNSPECIFIED LogSink_VersionFormat = 0
	// `LogEntry` version 2 format.
	LogSink_V2 LogSink_VersionFormat = 1
	// `LogEntry` version 1 format.
	LogSink_V1 LogSink_VersionFormat = 2
)

var LogSink_VersionFormat_name = map[int32]string{
	0: "VERSION_FORMAT_UNSPECIFIED",
	1: "V2",
	2: "V1",
}
var LogSink_VersionFormat_value = map[string]int32{
	"VERSION_FORMAT_UNSPECIFIED": 0,
	"V2": 1,
	"V1": 2,
}

func (x LogSink_VersionFormat) String() string {
	return proto.EnumName(LogSink_VersionFormat_name, int32(x))
}
func (LogSink_VersionFormat) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{0, 0} }

// Describes a sink used to export log entries to one of the following
// destinations in any project: a Cloud Storage bucket, a BigQuery dataset, or a
// Cloud Pub/Sub topic.  A logs filter controls which log entries are
// exported. The sink must be created within a project, organization, billing
// account, or folder.
type LogSink struct {
	// Required. The client-assigned sink identifier, unique within the
	// project. Example: `"my-syslog-errors-to-pubsub"`.  Sink identifiers are
	// limited to 100 characters and can include only the following characters:
	// upper and lower-case alphanumeric characters, underscores, hyphens, and
	// periods.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Required. The export destination:
	//
	//     "storage.googleapis.com/[GCS_BUCKET]"
	//     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
	//     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
	//
	// The sink's `writer_identity`, set when the sink is created, must
	// have permission to write to the destination or else the log
	// entries are not exported.  For more information, see
	// [Exporting Logs With Sinks](/logging/docs/api/tasks/exporting-logs).
	Destination string `protobuf:"bytes,3,opt,name=destination" json:"destination,omitempty"`
	// Optional.
	// An [advanced logs filter](/logging/docs/view/advanced_filters).  The only
	// exported log entries are those that are in the resource owning the sink and
	// that match the filter. The filter must use the log entry format specified
	// by the `output_version_format` parameter.  For example, in the v2 format:
	//
	//     logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity>=ERROR
	Filter string `protobuf:"bytes,5,opt,name=filter" json:"filter,omitempty"`
	// Deprecated. The log entry format to use for this sink's exported log
	// entries.  The v2 format is used by default and cannot be changed.
	OutputVersionFormat LogSink_VersionFormat `protobuf:"varint,6,opt,name=output_version_format,json=outputVersionFormat,enum=google.logging.v2.LogSink_VersionFormat" json:"output_version_format,omitempty"`
	// Output only. An IAM identity&mdash;a service account or group&mdash;under
	// which Stackdriver Logging writes the exported log entries to the sink's
	// destination.  This field is set by
	// [sinks.create](/logging/docs/api/reference/rest/v2/projects.sinks/create)
	// and
	// [sinks.update](/logging/docs/api/reference/rest/v2/projects.sinks/update),
	// based on the setting of `unique_writer_identity` in those methods.
	//
	// Until you grant this identity write-access to the destination, log entry
	// exports from this sink will fail. For more information,
	// see [Granting access for a
	// resource](/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
	// Consult the destination service's documentation to determine the
	// appropriate IAM roles to assign to the identity.
	WriterIdentity string `protobuf:"bytes,8,opt,name=writer_identity,json=writerIdentity" json:"writer_identity,omitempty"`
	// Optional. This field applies only to sinks owned by organizations and
	// folders. If the field is false, the default, only the logs owned by the
	// sink's parent resource are available for export. If the field is true, then
	// logs from all the projects, folders, and billing accounts contained in the
	// sink's parent resource are also available for export. Whether a particular
	// log entry from the children is exported depends on the sink's filter
	// expression. For example, if this field is true, then the filter
	// `resource.type=gce_instance` would export all Compute Engine VM instance
	// log entries from all projects in the sink's parent. To only export entries
	// from certain child projects, filter on the project part of the log name:
	//
	//     logName:("projects/test-project1/" OR "projects/test-project2/") AND
	//     resource.type=gce_instance
	IncludeChildren bool `protobuf:"varint,9,opt,name=include_children,json=includeChildren" json:"include_children,omitempty"`
	// Optional. The time at which this sink will begin exporting log entries.
	// Log entries are exported only if their timestamp is not earlier than the
	// start time.  The default value of this field is the time the sink is
	// created or updated.
	StartTime *google_protobuf4.Timestamp `protobuf:"bytes,10,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Optional. The time at which this sink will stop exporting log entries.  Log
	// entries are exported only if their timestamp is earlier than the end time.
	// If this field is not supplied, there is no end time.  If both a start time
	// and an end time are provided, then the end time must be later than the
	// start time.
	EndTime *google_protobuf4.Timestamp `protobuf:"bytes,11,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
}

func (m *LogSink) Reset()                    { *m = LogSink{} }
func (m *LogSink) String() string            { return proto.CompactTextString(m) }
func (*LogSink) ProtoMessage()               {}
func (*LogSink) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *LogSink) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LogSink) GetDestination() string {
	if m != nil {
		return m.Destination
	}
	return ""
}

func (m *LogSink) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *LogSink) GetOutputVersionFormat() LogSink_VersionFormat {
	if m != nil {
		return m.OutputVersionFormat
	}
	return LogSink_VERSION_FORMAT_UNSPECIFIED
}

func (m *LogSink) GetWriterIdentity() string {
	if m != nil {
		return m.WriterIdentity
	}
	return ""
}

func (m *LogSink) GetIncludeChildren() bool {
	if m != nil {
		return m.IncludeChildren
	}
	return false
}

func (m *LogSink) GetStartTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *LogSink) GetEndTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// The parameters to `ListSinks`.
type ListSinksRequest struct {
	// Required. The parent resource whose sinks are to be listed:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListSinksRequest) Reset()                    { *m = ListSinksRequest{} }
func (m *ListSinksRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSinksRequest) ProtoMessage()               {}
func (*ListSinksRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

func (m *ListSinksRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSinksRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListSinksRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Result returned from `ListSinks`.
type ListSinksResponse struct {
	// A list of sinks.
	Sinks []*LogSink `protobuf:"bytes,1,rep,name=sinks" json:"sinks,omitempty"`
	// If there might be more results than appear in this response, then
	// `nextPageToken` is included.  To get the next set of results, call the same
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListSinksResponse) Reset()                    { *m = ListSinksResponse{} }
func (m *ListSinksResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSinksResponse) ProtoMessage()               {}
func (*ListSinksResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

func (m *ListSinksResponse) GetSinks() []*LogSink {
	if m != nil {
		return m.Sinks
	}
	return nil
}

func (m *ListSinksResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to `GetSink`.
type GetSinkRequest struct {
	// Required. The resource name of the sink:
	//
	//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
	//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
	//     "folders/[FOLDER_ID]/sinks/[SINK_ID]"
	//
	// Example: `"projects/my-project-id/sinks/my-sink-id"`.
	SinkName string `protobuf:"bytes,1,opt,name=sink_name,json=sinkName" json:"sink_name,omitempty"`
}

func (m *GetSinkRequest) Reset()                    { *m = GetSinkRequest{} }
func (m *GetSinkRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSinkRequest) ProtoMessage()               {}
func (*GetSinkRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

func (m *GetSinkRequest) GetSinkName() string {
	if m != nil {
		return m.SinkName
	}
	return ""
}

// The parameters to `CreateSink`.
type CreateSinkRequest struct {
	// Required. The resource in which to create the sink:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	//
	// Examples: `"projects/my-logging-project"`, `"organizations/123456789"`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The new sink, whose `name` parameter is a sink identifier that
	// is not already in use.
	Sink *LogSink `protobuf:"bytes,2,opt,name=sink" json:"sink,omitempty"`
	// Optional. Determines the kind of IAM identity returned as `writer_identity`
	// in the new sink.  If this value is omitted or set to false, and if the
	// sink's parent is a project, then the value returned as `writer_identity` is
	// the same group or service account used by Stackdriver Logging before the
	// addition of writer identities to this API. The sink's destination must be
	// in the same project as the sink itself.
	//
	// If this field is set to true, or if the sink is owned by a non-project
	// resource such as an organization, then the value of `writer_identity` will
	// be a unique service account used only for exports from the new sink.  For
	// more information, see `writer_identity` in [LogSink][google.logging.v2.LogSink].
	UniqueWriterIdentity bool `protobuf:"varint,3,opt,name=unique_writer_identity,json=uniqueWriterIdentity" json:"unique_writer_identity,omitempty"`
}

func (m *CreateSinkRequest) Reset()                    { *m = CreateSinkRequest{} }
func (m *CreateSinkRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateSinkRequest) ProtoMessage()               {}
func (*CreateSinkRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

func (m *CreateSinkRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateSinkRequest) GetSink() *LogSink {
	if m != nil {
		return m.Sink
	}
	return nil
}

func (m *CreateSinkRequest) GetUniqueWriterIdentity() bool {
	if m != nil {
		return m.UniqueWriterIdentity
	}
	return false
}

// The parameters to `UpdateSink`.
type UpdateSinkRequest struct {
	// Required. The full resource name of the sink to update, including the
	// parent resource and the sink identifier:
	//
	//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
	//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
	//     "folders/[FOLDER_ID]/sinks/[SINK_ID]"
	//
	// Example: `"projects/my-project-id/sinks/my-sink-id"`.
	SinkName string `protobuf:"bytes,1,opt,name=sink_name,json=sinkName" json:"sink_name,omitempty"`
	// Required. The updated sink, whose name is the same identifier that appears
	// as part of `sink_name`.
	Sink *LogSink `protobuf:"bytes,2,opt,name=sink" json:"sink,omitempty"`
	// Optional. See
	// [sinks.create](/logging/docs/api/reference/rest/v2/projects.sinks/create)
	// for a description of this field.  When updating a sink, the effect of this
	// field on the value of `writer_identity` in the updated sink depends on both
	// the old and new values of this field:
	//
	// +   If the old and new values of this field are both false or both true,
	//     then there is no change to the sink's `writer_identity`.
	// +   If the old value is false and the new value is true, then
	//     `writer_identity` is changed to a unique service account.
	// +   It is an error if the old value is true and the new value is
	//     set to false or defaulted to false.
	UniqueWriterIdentity bool `protobuf:"varint,3,opt,name=unique_writer_identity,json=uniqueWriterIdentity" json:"unique_writer_identity,omitempty"`
}

func (m *UpdateSinkRequest) Reset()                    { *m = UpdateSinkRequest{} }
func (m *UpdateSinkRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateSinkRequest) ProtoMessage()               {}
func (*UpdateSinkRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *UpdateSinkRequest) GetSinkName() string {
	if m != nil {
		return m.SinkName
	}
	return ""
}

func (m *UpdateSinkRequest) GetSink() *LogSink {
	if m != nil {
		return m.Sink
	}
	return nil
}

func (m *UpdateSinkRequest) GetUniqueWriterIdentity() bool {
	if m != nil {
		return m.UniqueWriterIdentity
	}
	return false
}

// The parameters to `DeleteSink`.
type DeleteSinkRequest struct {
	// Required. The full resource name of the sink to delete, including the
	// parent resource and the sink identifier:
	//
	//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
	//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
	//     "folders/[FOLDER_ID]/sinks/[SINK_ID]"
	//
	// Example: `"projects/my-project-id/sinks/my-sink-id"`.
	SinkName string `protobuf:"bytes,1,opt,name=sink_name,json=sinkName" json:"sink_name,omitempty"`
}

func (m *DeleteSinkRequest) Reset()                    { *m = DeleteSinkRequest{} }
func (m *DeleteSinkRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSinkRequest) ProtoMessage()               {}
func (*DeleteSinkRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

func (m *DeleteSinkRequest) GetSinkName() string {
	if m != nil {
		return m.SinkName
	}
	return ""
}

// Specifies a set of log entries that are not to be stored in Stackdriver
// Logging. If your project receives a large volume of logs, you might be able
// to use exclusions to reduce your chargeable logs. Exclusions are processed
// after log sinks, so you can export log entries before they are excluded.
// Audit log entries and log entries from Amazon Web Services are never
// excluded.
type LogExclusion struct {
	// Required. A client-assigned identifier, such as
	// `"load-balancer-exclusion"`. Identifiers are limited to 100 characters and
	// can include only letters, digits, underscores, hyphens, and periods.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional. A description of this exclusion.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Required.
	// An [advanced logs filter](/logging/docs/view/advanced_filters)
	// that matches the log entries to be excluded. By using the
	// [sample function](/logging/docs/view/advanced_filters#sample),
	// you can exclude less than 100% of the matching log entries.
	// For example, the following filter matches 99% of low-severity log
	// entries from load balancers:
	//
	//     "resource.type=http_load_balancer severity<ERROR sample(insertId, 0.99)"
	Filter string `protobuf:"bytes,3,opt,name=filter" json:"filter,omitempty"`
	// Optional. If set to True, then this exclusion is disabled and it does not
	// exclude any log entries. You can use
	// [exclusions.patch](/logging/docs/alpha-exclusion/docs/reference/v2/rest/v2/projects.exclusions/patch)
	// to change the value of this field.
	Disabled bool `protobuf:"varint,4,opt,name=disabled" json:"disabled,omitempty"`
}

func (m *LogExclusion) Reset()                    { *m = LogExclusion{} }
func (m *LogExclusion) String() string            { return proto.CompactTextString(m) }
func (*LogExclusion) ProtoMessage()               {}
func (*LogExclusion) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

func (m *LogExclusion) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LogExclusion) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *LogExclusion) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *LogExclusion) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// The parameters to `ListExclusions`.
type ListExclusionsRequest struct {
	// Required. The parent resource whose exclusions are to be listed.
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListExclusionsRequest) Reset()                    { *m = ListExclusionsRequest{} }
func (m *ListExclusionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListExclusionsRequest) ProtoMessage()               {}
func (*ListExclusionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *ListExclusionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListExclusionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListExclusionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Result returned from `ListExclusions`.
type ListExclusionsResponse struct {
	// A list of exclusions.
	Exclusions []*LogExclusion `protobuf:"bytes,1,rep,name=exclusions" json:"exclusions,omitempty"`
	// If there might be more results than appear in this response, then
	// `nextPageToken` is included.  To get the next set of results, call the same
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListExclusionsResponse) Reset()                    { *m = ListExclusionsResponse{} }
func (m *ListExclusionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListExclusionsResponse) ProtoMessage()               {}
func (*ListExclusionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{9} }

func (m *ListExclusionsResponse) GetExclusions() []*LogExclusion {
	if m != nil {
		return m.Exclusions
	}
	return nil
}

func (m *ListExclusionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to `GetExclusion`.
type GetExclusionRequest struct {
	// Required. The resource name of an existing exclusion:
	//
	//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
	//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
	//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
	//
	// Example: `"projects/my-project-id/exclusions/my-exclusion-id"`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetExclusionRequest) Reset()                    { *m = GetExclusionRequest{} }
func (m *GetExclusionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetExclusionRequest) ProtoMessage()               {}
func (*GetExclusionRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{10} }

func (m *GetExclusionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The parameters to `CreateExclusion`.
type CreateExclusionRequest struct {
	// Required. The parent resource in which to create the exclusion:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	//
	// Examples: `"projects/my-logging-project"`, `"organizations/123456789"`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The new exclusion, whose `name` parameter is an exclusion name
	// that is not already used in the parent resource.
	Exclusion *LogExclusion `protobuf:"bytes,2,opt,name=exclusion" json:"exclusion,omitempty"`
}

func (m *CreateExclusionRequest) Reset()                    { *m = CreateExclusionRequest{} }
func (m *CreateExclusionRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateExclusionRequest) ProtoMessage()               {}
func (*CreateExclusionRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{11} }

func (m *CreateExclusionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateExclusionRequest) GetExclusion() *LogExclusion {
	if m != nil {
		return m.Exclusion
	}
	return nil
}

// The parameters to `UpdateExclusion`.
type UpdateExclusionRequest struct {
	// Required. The resource name of the exclusion to update:
	//
	//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
	//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
	//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
	//
	// Example: `"projects/my-project-id/exclusions/my-exclusion-id"`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Required. New values for the existing exclusion. Only the fields specified
	// in `update_mask` are relevant.
	Exclusion *LogExclusion `protobuf:"bytes,2,opt,name=exclusion" json:"exclusion,omitempty"`
	// Required. A nonempty list of fields to change in the existing exclusion.
	// New values for the fields are taken from the corresponding fields in the
	// [LogExclusion][google.logging.v2.LogExclusion] included in this request. Fields not mentioned in
	// `update_mask` are not changed and are ignored in the request.
	//
	// For example, to change the filter and description of an exclusion,
	// specify an `update_mask` of `"filter,description"`.
	UpdateMask *google_protobuf6.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateExclusionRequest) Reset()                    { *m = UpdateExclusionRequest{} }
func (m *UpdateExclusionRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateExclusionRequest) ProtoMessage()               {}
func (*UpdateExclusionRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{12} }

func (m *UpdateExclusionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateExclusionRequest) GetExclusion() *LogExclusion {
	if m != nil {
		return m.Exclusion
	}
	return nil
}

func (m *UpdateExclusionRequest) GetUpdateMask() *google_protobuf6.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The parameters to `DeleteExclusion`.
type DeleteExclusionRequest struct {
	// Required. The resource name of an existing exclusion to delete:
	//
	//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
	//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
	//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
	//
	// Example: `"projects/my-project-id/exclusions/my-exclusion-id"`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteExclusionRequest) Reset()                    { *m = DeleteExclusionRequest{} }
func (m *DeleteExclusionRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteExclusionRequest) ProtoMessage()               {}
func (*DeleteExclusionRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{13} }

func (m *DeleteExclusionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*LogSink)(nil), "google.logging.v2.LogSink")
	proto.RegisterType((*ListSinksRequest)(nil), "google.logging.v2.ListSinksRequest")
	proto.RegisterType((*ListSinksResponse)(nil), "google.logging.v2.ListSinksResponse")
	proto.RegisterType((*GetSinkRequest)(nil), "google.logging.v2.GetSinkRequest")
	proto.RegisterType((*CreateSinkRequest)(nil), "google.logging.v2.CreateSinkRequest")
	proto.RegisterType((*UpdateSinkRequest)(nil), "google.logging.v2.UpdateSinkRequest")
	proto.RegisterType((*DeleteSinkRequest)(nil), "google.logging.v2.DeleteSinkRequest")
	proto.RegisterType((*LogExclusion)(nil), "google.logging.v2.LogExclusion")
	proto.RegisterType((*ListExclusionsRequest)(nil), "google.logging.v2.ListExclusionsRequest")
	proto.RegisterType((*ListExclusionsResponse)(nil), "google.logging.v2.ListExclusionsResponse")
	proto.RegisterType((*GetExclusionRequest)(nil), "google.logging.v2.GetExclusionRequest")
	proto.RegisterType((*CreateExclusionRequest)(nil), "google.logging.v2.CreateExclusionRequest")
	proto.RegisterType((*UpdateExclusionRequest)(nil), "google.logging.v2.UpdateExclusionRequest")
	proto.RegisterType((*DeleteExclusionRequest)(nil), "google.logging.v2.DeleteExclusionRequest")
	proto.RegisterEnum("google.logging.v2.LogSink_VersionFormat", LogSink_VersionFormat_name, LogSink_VersionFormat_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ConfigServiceV2 service

type ConfigServiceV2Client interface {
	// Lists sinks.
	ListSinks(ctx context.Context, in *ListSinksRequest, opts ...grpc.CallOption) (*ListSinksResponse, error)
	// Gets a sink.
	GetSink(ctx context.Context, in *GetSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Creates a sink that exports specified log entries to a destination.  The
	// export of newly-ingested log entries begins immediately, unless the current
	// time is outside the sink's start and end times or the sink's
	// `writer_identity` is not permitted to write to the destination.  A sink can
	// export log entries only from the resource owning the sink.
	CreateSink(ctx context.Context, in *CreateSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Updates a sink.  This method replaces the following fields in the existing
	// sink with values from the new sink: `destination`, `filter`,
	// `output_version_format`, `start_time`, and `end_time`.
	// The updated sink might also have a new `writer_identity`; see the
	// `unique_writer_identity` field.
	UpdateSink(ctx context.Context, in *UpdateSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Deletes a sink. If the sink has a unique `writer_identity`, then that
	// service account is also deleted.
	DeleteSink(ctx context.Context, in *DeleteSinkRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error)
	// Lists all the exclusions in a parent resource.
	ListExclusions(ctx context.Context, in *ListExclusionsRequest, opts ...grpc.CallOption) (*ListExclusionsResponse, error)
	// Gets the description of an exclusion.
	GetExclusion(ctx context.Context, in *GetExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error)
	// Creates a new exclusion in a specified parent resource.
	// Only log entries belonging to that resource can be excluded.
	// You can have up to 10 exclusions in a resource.
	CreateExclusion(ctx context.Context, in *CreateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error)
	// Changes one or more properties of an existing exclusion.
	UpdateExclusion(ctx context.Context, in *UpdateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error)
	// Deletes an exclusion.
	DeleteExclusion(ctx context.Context, in *DeleteExclusionRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error)
}

type configServiceV2Client struct {
	cc *grpc.ClientConn
}

func NewConfigServiceV2Client(cc *grpc.ClientConn) ConfigServiceV2Client {
	return &configServiceV2Client{cc}
}

func (c *configServiceV2Client) ListSinks(ctx context.Context, in *ListSinksRequest, opts ...grpc.CallOption) (*ListSinksResponse, error) {
	out := new(ListSinksResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/ListSinks", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetSink(ctx context.Context, in *GetSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/GetSink", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateSink(ctx context.Context, in *CreateSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/CreateSink", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateSink(ctx context.Context, in *UpdateSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/UpdateSink", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) DeleteSink(ctx context.Context, in *DeleteSinkRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error) {
	out := new(google_protobuf5.Empty)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/DeleteSink", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) ListExclusions(ctx context.Context, in *ListExclusionsRequest, opts ...grpc.CallOption) (*ListExclusionsResponse, error) {
	out := new(ListExclusionsResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/ListExclusions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetExclusion(ctx context.Context, in *GetExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error) {
	out := new(LogExclusion)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/GetExclusion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateExclusion(ctx context.Context, in *CreateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error) {
	out := new(LogExclusion)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/CreateExclusion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateExclusion(ctx context.Context, in *UpdateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error) {
	out := new(LogExclusion)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/UpdateExclusion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) DeleteExclusion(ctx context.Context, in *DeleteExclusionRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error) {
	out := new(google_protobuf5.Empty)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/DeleteExclusion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ConfigServiceV2 service

type ConfigServiceV2Server interface {
	// Lists sinks.
	ListSinks(context.Context, *ListSinksRequest) (*ListSinksResponse, error)
	// Gets a sink.
	GetSink(context.Context, *GetSinkRequest) (*LogSink, error)
	// Creates a sink that exports specified log entries to a destination.  The
	// export of newly-ingested log entries begins immediately, unless the current
	// time is outside the sink's start and end times or the sink's
	// `writer_identity` is not permitted to write to the destination.  A sink can
	// export log entries only from the resource owning the sink.
	CreateSink(context.Context, *CreateSinkRequest) (*LogSink, error)
	// Updates a sink.  This method replaces the following fields in the existing
	// sink with values from the new sink: `destination`, `filter`,
	// `output_version_format`, `start_time`, and `end_time`.
	// The updated sink might also have a new `writer_identity`; see the
	// `unique_writer_identity` field.
	UpdateSink(context.Context, *UpdateSinkRequest) (*LogSink, error)
	// Deletes a sink. If the sink has a unique `writer_identity`, then that
	// service account is also deleted.
	DeleteSink(context.Context, *DeleteSinkRequest) (*google_protobuf5.Empty, error)
	// Lists all the exclusions in a parent resource.
	ListExclusions(context.Context, *ListExclusionsRequest) (*ListExclusionsResponse, error)
	// Gets the description of an exclusion.
	GetExclusion(context.Context, *GetExclusionRequest) (*LogExclusion, error)
	// Creates a new exclusion in a specified parent resource.
	// Only log entries belonging to that resource can be excluded.
	// You can have up to 10 exclusions in a resource.
	CreateExclusion(context.Context, *CreateExclusionRequest) (*LogExclusion, error)
	// Changes one or more properties of an existing exclusion.
	UpdateExclusion(context.Context, *UpdateExclusionRequest) (*LogExclusion, error)
	// Deletes an exclusion.
	DeleteExclusion(context.Context, *DeleteExclusionRequest) (*google_protobuf5.Empty, error)
}

func RegisterConfigServiceV2Server(s *grpc.Server, srv ConfigServiceV2Server) {
	s.RegisterService(&_ConfigServiceV2_serviceDesc, srv)
}

func _ConfigServiceV2_ListSinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListSinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/ListSinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListSinks(ctx, req.(*ListSinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/GetSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetSink(ctx, req.(*GetSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/CreateSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateSink(ctx, req.(*CreateSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/UpdateSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateSink(ctx, req.(*UpdateSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_DeleteSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).DeleteSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/DeleteSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).DeleteSink(ctx, req.(*DeleteSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_ListExclusions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExclusionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListExclusions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/ListExclusions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListExclusions(ctx, req.(*ListExclusionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/GetExclusion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetExclusion(ctx, req.(*GetExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/CreateExclusion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateExclusion(ctx, req.(*CreateExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/UpdateExclusion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateExclusion(ctx, req.(*UpdateExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_DeleteExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).DeleteExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/DeleteExclusion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).DeleteExclusion(ctx, req.(*DeleteExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConfigServiceV2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.logging.v2.ConfigServiceV2",
	HandlerType: (*ConfigServiceV2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSinks",
			Handler:    _ConfigServiceV2_ListSinks_Handler,
		},
		{
			MethodName: "GetSink",
			Handler:    _ConfigServiceV2_GetSink_Handler,
		},
		{
			MethodName: "CreateSink",
			Handler:    _ConfigServiceV2_CreateSink_Handler,
		},
		{
			MethodName: "UpdateSink",
			Handler:    _ConfigServiceV2_UpdateSink_Handler,
		},
		{
			MethodName: "DeleteSink",
			Handler:    _ConfigServiceV2_DeleteSink_Handler,
		},
		{
			MethodName: "ListExclusions",
			Handler:    _ConfigServiceV2_ListExclusions_Handler,
		},
		{
			MethodName: "GetExclusion",
			Handler:    _ConfigServiceV2_GetExclusion_Handler,
		},
		{
			MethodName: "CreateExclusion",
			Handler:    _ConfigServiceV2_CreateExclusion_Handler,
		},
		{
			MethodName: "UpdateExclusion",
			Handler:    _ConfigServiceV2_UpdateExclusion_Handler,
		},
		{
			MethodName: "DeleteExclusion",
			Handler:    _ConfigServiceV2_DeleteExclusion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/logging/v2/logging_config.proto",
}

func init() { proto.RegisterFile("google/logging/v2/logging_config.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 1109 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0xff, 0x6e, 0xdb, 0x54,
	0x14, 0xc6, 0xe9, 0xda, 0x26, 0xa7, 0x5b, 0xd3, 0xde, 0xd1, 0x10, 0xb9, 0x8c, 0x06, 0xb3, 0x95,
	0xb4, 0x80, 0x53, 0x02, 0x93, 0x60, 0xd3, 0x34, 0xb1, 0xae, 0xad, 0x2a, 0x75, 0x5d, 0xe5, 0x76,
	0x45, 0x42, 0x48, 0x96, 0x1b, 0xdf, 0x98, 0x4b, 0x1d, 0x5f, 0xcf, 0xbe, 0x09, 0xdd, 0xa6, 0x4a,
	0xe3, 0xc7, 0x0b, 0x4c, 0x20, 0x9e, 0x01, 0xf1, 0x0c, 0xbc, 0x00, 0x7f, 0xf3, 0x0a, 0x3c, 0x04,
	0x7f, 0xa2, 0xfb, 0x23, 0x89, 0xe3, 0xb8, 0xa9, 0x11, 0x82, 0xbf, 0x7a, 0xef, 0xb9, 0xe7, 0xf8,
	0xfb, 0xce, 0xb9, 0x9f, 0x3f, 0xa7, 0xb0, 0xea, 0x51, 0xea, 0xf9, 0xb8, 0xe1, 0x53, 0xcf, 0x23,
	0x81, 0xd7, 0xe8, 0x35, 0xfb, 0x4b, 0xbb, 0x45, 0x83, 0x36, 0xf1, 0xcc, 0x30, 0xa2, 0x8c, 0xa2,
	0x45, 0x99, 0x67, 0xaa, 0x43, 0xb3, 0xd7, 0xd4, 0xdf, 0x54, 0xa5, 0x4e, 0x48, 0x1a, 0x4e, 0x10,
	0x50, 0xe6, 0x30, 0x42, 0x83, 0x58, 0x16, 0xe8, 0xcb, 0xea, 0x54, 0xec, 0x4e, 0xba, 0xed, 0x06,
	0xee, 0x84, 0xec, 0x99, 0x3a, 0xac, 0xa5, 0x0f, 0xdb, 0x04, 0xfb, 0xae, 0xdd, 0x71, 0xe2, 0x53,
	0x95, 0xb1, 0x92, 0xce, 0x60, 0xa4, 0x83, 0x63, 0xe6, 0x74, 0x42, 0x99, 0x60, 0xfc, 0x36, 0x05,
	0xb3, 0x7b, 0xd4, 0x3b, 0x24, 0xc1, 0x29, 0x42, 0x70, 0x25, 0x70, 0x3a, 0xb8, 0xaa, 0xd5, 0xb4,
	0x7a, 0xc9, 0x12, 0x6b, 0x54, 0x83, 0x39, 0x17, 0xc7, 0x8c, 0x04, 0x82, 0x55, 0x75, 0x4a, 0x1c,
	0x25, 0x43, 0xa8, 0x02, 0x33, 0x6d, 0xe2, 0x33, 0x1c, 0x55, 0xa7, 0xc5, 0xa1, 0xda, 0xa1, 0x2f,
	0x61, 0x89, 0x76, 0x59, 0xd8, 0x65, 0x76, 0x0f, 0x47, 0x31, 0xa1, 0x81, 0xdd, 0xa6, 0x51, 0xc7,
	0x61, 0xd5, 0x99, 0x9a, 0x56, 0x9f, 0x6f, 0xd6, 0xcd, 0xb1, 0x51, 0x98, 0x8a, 0x88, 0x79, 0x2c,
	0x0b, 0xb6, 0x45, 0xbe, 0x75, 0x5d, 0x3e, 0x66, 0x24, 0x88, 0xde, 0x85, 0xf2, 0x37, 0x11, 0x61,
	0x38, 0xb2, 0x89, 0x8b, 0x03, 0x46, 0xd8, 0xb3, 0x6a, 0x51, 0xc0, 0xcf, 0xcb, 0xf0, 0xae, 0x8a,
	0xa2, 0x35, 0x58, 0x20, 0x41, 0xcb, 0xef, 0xba, 0xd8, 0x6e, 0x7d, 0x45, 0x7c, 0x37, 0xc2, 0x41,
	0xb5, 0x54, 0xd3, 0xea, 0x45, 0xab, 0xac, 0xe2, 0x9b, 0x2a, 0x8c, 0x3e, 0x05, 0x88, 0x99, 0x13,
	0x31, 0x9b, 0x0f, 0xa9, 0x0a, 0x35, 0xad, 0x3e, 0xd7, 0xd4, 0xfb, 0x34, 0xfb, 0x13, 0x34, 0x8f,
	0xfa, 0x13, 0xb4, 0x4a, 0x22, 0x9b, 0xef, 0xd1, 0x6d, 0x28, 0xe2, 0xc0, 0x95, 0x85, 0x73, 0x97,
	0x16, 0xce, 0xe2, 0xc0, 0xe5, 0x3b, 0xe3, 0x3e, 0x5c, 0x1b, 0x6d, 0xeb, 0x2d, 0xd0, 0x8f, 0xb7,
	0xac, 0xc3, 0xdd, 0xc7, 0xfb, 0xf6, 0xf6, 0x63, 0xeb, 0xd1, 0x67, 0x47, 0xf6, 0x93, 0xfd, 0xc3,
	0x83, 0xad, 0xcd, 0xdd, 0xed, 0xdd, 0xad, 0x87, 0x0b, 0xaf, 0xa1, 0x19, 0x28, 0x1c, 0x37, 0x17,
	0x34, 0xf1, 0xf7, 0xc3, 0x85, 0x82, 0xd1, 0x86, 0x85, 0x3d, 0x12, 0x33, 0x3e, 0xb5, 0xd8, 0xc2,
	0x4f, 0xbb, 0x38, 0x66, 0xfc, 0x42, 0x42, 0x27, 0xc2, 0x01, 0x53, 0x17, 0xa9, 0x76, 0xe8, 0x06,
	0x40, 0xe8, 0x78, 0xd8, 0x66, 0xf4, 0x14, 0x07, 0xd5, 0x82, 0x38, 0x2b, 0xf1, 0xc8, 0x11, 0x0f,
	0xa0, 0x65, 0x10, 0x1b, 0x3b, 0x26, 0xcf, 0xb1, 0xb8, 0xe7, 0x69, 0xab, 0xc8, 0x03, 0x87, 0xe4,
	0x39, 0x36, 0x3a, 0xb0, 0x98, 0xc0, 0x89, 0x43, 0x1a, 0xc4, 0x18, 0x6d, 0xc0, 0x74, 0xcc, 0x03,
	0x55, 0xad, 0x36, 0x95, 0xec, 0x78, 0xfc, 0x46, 0x2d, 0x99, 0x88, 0x56, 0xa1, 0x1c, 0xe0, 0x33,
	0x66, 0x8f, 0xf1, 0xb8, 0xc6, 0xc3, 0x07, 0x7d, 0x2e, 0xc6, 0x07, 0x30, 0xbf, 0x83, 0x05, 0x5a,
	0xbf, 0xa9, 0x65, 0x28, 0xf1, 0x47, 0xd8, 0x09, 0x81, 0x16, 0x79, 0x60, 0xdf, 0xe9, 0x60, 0xe3,
	0x95, 0x06, 0x8b, 0x9b, 0x11, 0x76, 0x18, 0x4e, 0x96, 0x5c, 0x34, 0x07, 0x13, 0xae, 0xf0, 0x4a,
	0x81, 0x3c, 0x99, 0xb5, 0xc8, 0x43, 0x1f, 0x43, 0xa5, 0x1b, 0x90, 0xa7, 0x5d, 0x6c, 0xa7, 0x15,
	0x37, 0x25, 0x74, 0xf4, 0xba, 0x3c, 0xfd, 0x7c, 0x44, 0x77, 0xc6, 0xcf, 0x1a, 0x2c, 0x3e, 0x09,
	0xdd, 0x14, 0xa7, 0x49, 0x6d, 0xfc, 0x4f, 0xc4, 0x36, 0x60, 0xf1, 0x21, 0xf6, 0x71, 0x7e, 0x5e,
	0xc6, 0x19, 0x5c, 0xdd, 0xa3, 0xde, 0xd6, 0x59, 0xcb, 0xef, 0x72, 0xa9, 0x4e, 0xf0, 0x89, 0x56,
	0x44, 0x42, 0xe1, 0x13, 0x85, 0x81, 0x4f, 0xf4, 0x43, 0x09, 0x9f, 0x98, 0x1a, 0xf1, 0x09, 0x1d,
	0x8a, 0x2e, 0x89, 0x9d, 0x13, 0x1f, 0xbb, 0xd5, 0x2b, 0x82, 0xf7, 0x60, 0x6f, 0x9c, 0xc2, 0x12,
	0x97, 0xdd, 0x00, 0xfa, 0x3f, 0xd5, 0xf8, 0xb7, 0x1a, 0x54, 0xd2, 0x68, 0x4a, 0xe9, 0xf7, 0x01,
	0xf0, 0x20, 0xaa, 0xe4, 0xbe, 0x92, 0x7d, 0x3f, 0x83, 0x6a, 0x2b, 0x51, 0x92, 0x5b, 0xf8, 0x6b,
	0x70, 0x7d, 0x07, 0x0f, 0x19, 0xf4, 0xdb, 0xcd, 0x98, 0xb8, 0x41, 0xa1, 0x22, 0x35, 0x3f, 0x96,
	0x7d, 0xd1, 0x70, 0xee, 0x41, 0x69, 0x40, 0x49, 0x89, 0xec, 0xd2, 0x26, 0x86, 0x15, 0xc6, 0x2f,
	0x1a, 0x54, 0xa4, 0xa2, 0xf3, 0xf0, 0xfb, 0x97, 0x68, 0xe8, 0x2e, 0xcc, 0x75, 0x05, 0x98, 0xf8,
	0x9c, 0x89, 0xcb, 0xca, 0x32, 0xd5, 0x6d, 0xfe, 0xc5, 0x7b, 0xe4, 0xc4, 0xa7, 0x16, 0xc8, 0x74,
	0xbe, 0x36, 0xde, 0x87, 0x8a, 0xd4, 0x78, 0x1e, 0xa6, 0xcd, 0xdf, 0x01, 0xca, 0x9b, 0xe2, 0x2b,
	0x7d, 0x88, 0xa3, 0x1e, 0x69, 0xe1, 0xe3, 0x26, 0x3a, 0x87, 0xd2, 0xc0, 0xf0, 0xd0, 0x3b, 0x59,
	0xbc, 0x53, 0xb6, 0xab, 0xdf, 0x9c, 0x9c, 0x24, 0x95, 0x64, 0xdc, 0xfa, 0xee, 0x8f, 0x3f, 0x7f,
	0x2c, 0xac, 0xa0, 0x1b, 0xfc, 0x27, 0xc2, 0x0b, 0x79, 0x31, 0xf7, 0xc2, 0x88, 0x7e, 0x8d, 0x5b,
	0x2c, 0x6e, 0xac, 0x9f, 0x37, 0xa4, 0x51, 0x32, 0x98, 0x55, 0x06, 0x88, 0xde, 0xce, 0x78, 0xee,
	0xa8, 0x39, 0xea, 0x13, 0xac, 0xc2, 0x58, 0x17, 0x80, 0x37, 0x91, 0x21, 0x00, 0x07, 0x2f, 0x79,
	0x02, 0x53, 0x42, 0x36, 0xd6, 0xcf, 0xd1, 0x0b, 0x80, 0xa1, 0x8d, 0xa2, 0xac, 0x86, 0xc6, 0x5c,
	0x76, 0x22, 0xf6, 0x7b, 0x02, 0xfb, 0x96, 0x31, 0xb9, 0xd9, 0x3b, 0xd2, 0xcd, 0x5e, 0x6a, 0x00,
	0x43, 0xc3, 0xcc, 0x44, 0x1f, 0xf3, 0xd3, 0x89, 0xe8, 0x1b, 0x02, 0x7d, 0x5d, 0xcf, 0xd1, 0xb9,
	0xa2, 0xd0, 0x03, 0x18, 0x5a, 0x63, 0x26, 0x83, 0x31, 0xe7, 0xd4, 0x2b, 0x63, 0x92, 0xdc, 0xe2,
	0xbf, 0xd0, 0xfa, 0x73, 0x5f, 0xcf, 0x33, 0xf7, 0x57, 0x1a, 0xcc, 0x8f, 0x3a, 0x0f, 0xaa, 0x5f,
	0xa0, 0xa6, 0x31, 0x2b, 0xd4, 0xd7, 0x72, 0x64, 0x2a, 0xf1, 0x8d, 0x6a, 0x21, 0xe3, 0x3e, 0x12,
	0x8e, 0xf5, 0xbd, 0x06, 0x57, 0x93, 0x56, 0x84, 0x56, 0xb3, 0x75, 0x98, 0x7e, 0xc3, 0xf4, 0xcb,
	0x5e, 0xf2, 0x14, 0x8b, 0xf4, 0x50, 0x86, 0x14, 0xf8, 0x64, 0x7e, 0xd2, 0xa0, 0x9c, 0x72, 0x39,
	0xb4, 0x76, 0xa1, 0x2e, 0xff, 0x39, 0x97, 0xdb, 0x82, 0x4b, 0xc3, 0xc8, 0x31, 0x91, 0x3b, 0x09,
	0x73, 0xe2, 0xb4, 0x52, 0x56, 0x98, 0x49, 0x2b, 0xdb, 0x2e, 0x73, 0xd3, 0x6a, 0xe6, 0x18, 0x51,
	0x92, 0xd6, 0x4b, 0x0d, 0xca, 0x29, 0xdf, 0xcb, 0xa4, 0x95, 0xed, 0x8d, 0x39, 0xa5, 0x3c, 0x91,
	0xcd, 0x83, 0x1f, 0x34, 0x58, 0x6a, 0xd1, 0xce, 0x38, 0xe8, 0x03, 0xb4, 0x27, 0xd7, 0xd2, 0x69,
	0x0f, 0x38, 0xc4, 0x81, 0xf6, 0xc5, 0x27, 0x2a, 0xd1, 0xa3, 0xbe, 0x13, 0x78, 0x26, 0x8d, 0xbc,
	0x86, 0x87, 0x03, 0x41, 0xa0, 0x21, 0x8f, 0x9c, 0x90, 0xc4, 0x89, 0xff, 0xab, 0xee, 0xaa, 0xe5,
	0x5f, 0x9a, 0xf6, 0x6b, 0xe1, 0x8d, 0x1d, 0x59, 0xbd, 0xe9, 0xd3, 0xae, 0x6b, 0x2a, 0x00, 0xf3,
	0xb8, 0x79, 0x32, 0x23, 0x9e, 0xf0, 0xd1, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0xa9, 0x26, 0x54,
	0x7c, 0x98, 0x0d, 0x00, 0x00,
}
