#!/bin/bash -e

echo ${PWD}

[ -f ./fpm_scripts/VERSION ] || (echo "ERROR: version not specified in fpm_scripts/VERSION" && exit 1)

VERSION=$(cat ./fpm_scripts/VERSION | tr -d '\040\011\012\015')

wget -q -O dist.tar.gz https://github.com/prometheus/node_exporter/releases/download/v${VERSION}/node_exporter-${VERSION}.linux-amd64.tar.gz

tar xvzf dist.tar.gz

mkdir -p fpm_source_xenial/usr/bin
mkdir -p fpm_source_precise/usr/bin

cp node_exporter-${VERSION}.linux-amd64/node_exporter fpm_source_xenial/usr/bin/prometheus-node-exporter
cp node_exporter-${VERSION}.linux-amd64/node_exporter fpm_source_precise/usr/bin/prometheus-node-exporter


