job {
  name 'availability-prometheus-config-build'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'availability/prometheus-config', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  throttleConcurrentBuilds {
    maxPerNode 2
  }
  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v'
    saveDeployArtifact 'availability/prometheus-config', '.manta'
  }
}

job {
  name 'availability-prometheus-config-deploy'
  using 'TEMPLATE-deploy'
  steps {
    shell 'courier deploy --repo availability/prometheus-config --dir /opt/twitch/prometheus-config'
  }
}
