#!/bin/bash

set -e -x

# We need to iterate over the teams and do the following for each:
# 1. Generate the prometheus config using the sample config, verify that it is correct with promtool
# 2. If everything is syntactically correct, extract the simple rules... they will get regenerated on the prometheus server
#    with the correct base config

for teamdir in ./teams/* ; do
  # Verify its a dir first
  [[ -d "${teamdir}" ]] || continue
  # Verify the scrapes.yaml file exists
  [[ ! -f "${teamdir}/scrapes.yaml" ]] && echo "ERROR: ${teamdir}/scrapes.yaml expected but not found" && exit 1
  # Build the config, or try to...
  ./generate.py --team $(basename $teamdir) --config-base ./sample_config/prometheus.base.yaml --output ./prometheus.test.yaml --rules-output ./rules.test.yaml
  [[ "$?" != "0" ]] && echo "ERROR: failure processing ${teamdir}/scrapes.yaml" && exit 1
  # Validate the generated config
  /usr/bin/promtool check config ./prometheus.test.yaml
  [[ "$?" != "0" ]] && echo "ERROR: ${teamdir}/scrapes.yaml generated and invalid prometheus configuration" && exit 1
  # Remove the created prometheus config before trying the next one
  rm -rf ./prometheus.test.yaml
  rm -rf ./rules.test.yaml
done

# Move the dist files into the extract directory for artifact creation
mkdir extract
cp -R teams generate.py courier extract/

