#!/bin/bash -e

echo ${PWD}

[ -f ./fpm_scripts/VERSION ] || (echo "ERROR: version not specified in fpm_scripts/VERSION" && exit 1)

VERSION=$(cat ./fpm_scripts/VERSION | tr -d '\040\011\012\015')

wget -q -O dist.tar.gz https://github.com/prometheus/prometheus/releases/download/v${VERSION}/prometheus-${VERSION}.linux-amd64.tar.gz

tar xvzf dist.tar.gz

mkdir -p fpm_source_xenial/usr/bin

cp prometheus-${VERSION}.linux-amd64/prometheus fpm_source_xenial/usr/bin/prometheus
cp prometheus-${VERSION}.linux-amd64/promtool fpm_source_xenial/usr/bin/promtool


