#!/bin/bash -e

echo ${PWD}

[ -f ./fpm_scripts/VERSION ] || (echo "ERROR: version not specified in fpm_scripts/VERSION" && exit 1)

VERSION=$(cat ./fpm_scripts/VERSION | tr -d '\040\011\012\015')

wget -q -O dist.tar.gz https://github.com/prometheus/pushgateway/releases/download/v${VERSION}/pushgateway-${VERSION}.linux-amd64.tar.gz

tar xvzf dist.tar.gz

mkdir -p fpm_source_xenial/usr/bin
mkdir -p fpm_source_precise/usr/bin

cp pushgateway-${VERSION}.linux-amd64/pushgateway fpm_source_xenial/usr/bin/prometheus-pushgateway
cp pushgateway-${VERSION}.linux-amd64/pushgateway fpm_source_precise/usr/bin/prometheus-pushgateway
