package main

import (
	"fmt"

	"code.justin.tv/systems/plucker/digestor"
)

func addAPIRequestEventRules(eventRules digestor.EventRules, apiRequests []APIRequest, countries []Country) {
	for _, apiRequest := range apiRequests {
		global := apiRequestGlobalEvent(apiRequest)
		country := apiRequestCountryEvent(apiRequest, countries)
		eventRules[networkRequest] = append(eventRules[networkRequest], global, country)
	}
}

func apiRequestGlobalEvent(apiRequest APIRequest) *digestor.EventConfig {
	return &digestor.EventConfig{
		StatType:   "timer",
		ValueField: "duration",
		Alias:      fmt.Sprintf("api_request.%s.global", apiRequest.GraphiteAlias()),
		FilterConfig: digestor.FilterConfig{
			Regex: map[string][]string{
				"request_url": []string{urlRegexPattern(apiRequest.Hostname, apiRequest.Path, true)},
			},
		},
	}
}

func apiRequestCountryEvent(apiRequest APIRequest, countries []Country) *digestor.EventConfig {
	return &digestor.EventConfig{
		StatType:   "timer",
		ValueField: "duration",
		Alias:      fmt.Sprintf("api_request.%s.{{.country}}", apiRequest.GraphiteAlias()),
		FilterConfig: digestor.FilterConfig{
			Equal: map[string][]string{
				"country": CountryCodes(countries),
			},
			Regex: map[string][]string{
				"request_url": []string{urlRegexPattern(apiRequest.Hostname, apiRequest.Path, true)},
			},
		},
	}
}
