package main

import (
	"fmt"

	"code.justin.tv/systems/plucker/digestor"
)

func addCDNRequestEventRules(eventRules digestor.EventRules, cdnRequests []CDNRequest, countries []Country) {
	for _, cdnRequest := range cdnRequests {
		global := cdnRequestGlobalEvent(cdnRequest)
		country := cdnRequestCountryEvent(cdnRequest, countries)
		eventRules[networkRequest] = append(eventRules[networkRequest], global, country)
	}
}

func cdnRequestGlobalEvent(cdnRequest CDNRequest) *digestor.EventConfig {
	return &digestor.EventConfig{
		StatType:   "timer",
		ValueField: "duration",
		Alias:      fmt.Sprintf("cdn_request.%s.global", cdnRequest.GraphiteAlias()),
		FilterConfig: digestor.FilterConfig{
			Regex: map[string][]string{
				"request_url": []string{urlRegexPattern(cdnRequest.Hostname, cdnRequest.Path, true)},
			},
		},
	}
}

func cdnRequestCountryEvent(cdnRequest CDNRequest, countries []Country) *digestor.EventConfig {
	return &digestor.EventConfig{
		StatType:   "timer",
		ValueField: "duration",
		Alias:      fmt.Sprintf("cdn_request.%s.{{.country}}", cdnRequest.GraphiteAlias()),
		FilterConfig: digestor.FilterConfig{
			Equal: map[string][]string{
				"country": CountryCodes(countries),
			},
			Regex: map[string][]string{
				"request_url": []string{urlRegexPattern(cdnRequest.Hostname, cdnRequest.Path, true)},
			},
		},
	}
}
