package main

import (
	"fmt"

	"code.justin.tv/systems/plucker/digestor"
)

const dnsDurationRegex = "^[1-9]"

func addDNSRequestEventRules(eventRules digestor.EventRules, dnsRequests []DNSRequest, countries []Country) {
	for _, dnsRequest := range dnsRequests {
		global := dnsRequestGlobalEvent(dnsRequest)
		country := dnsRequestCountryEvent(dnsRequest, countries)
		eventRules[networkRequest] = append(eventRules[networkRequest], global, country)
	}
}

func dnsRequestGlobalEvent(dnsRequest DNSRequest) *digestor.EventConfig {
	return &digestor.EventConfig{
		StatType:   "timer",
		ValueField: "dns_duration",
		Alias:      fmt.Sprintf("dns_request.%s.global", dnsRequest.GraphiteAlias()),
		FilterConfig: digestor.FilterConfig{
			Regex: map[string][]string{
				"request_url":  []string{urlRegexPattern(dnsRequest.Hostname, "", false)},
				"dns_duration": []string{dnsDurationRegex},
			},
		},
	}
}

func dnsRequestCountryEvent(dnsRequest DNSRequest, countries []Country) *digestor.EventConfig {
	return &digestor.EventConfig{
		StatType:   "timer",
		ValueField: "dns_duration",
		Alias:      fmt.Sprintf("dns_request.%s.{{.country}}", dnsRequest.GraphiteAlias()),
		FilterConfig: digestor.FilterConfig{
			Equal: map[string][]string{
				"country": CountryCodes(countries),
			},
			Regex: map[string][]string{
				"request_url":  []string{urlRegexPattern(dnsRequest.Hostname, "", false)},
				"dns_duration": []string{dnsDurationRegex},
			},
		},
	}
}
