package main

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestGraphiteSafeString(t *testing.T) {
	var tests = []struct {
		original string
		expected string
	}{
		{"a.b.c", "a_b_c"},
		{"a/b/c", "a_b_c"},
		{"a.b/c/d.e", "a_b_c_d_e"},
		{"1a2::3b4!!", "1a2_3b4_"},
		{"Hello, 世界", "Hello_世界"},
	}

	for _, test := range tests {
		assert.Equal(t, test.expected, graphiteSafeString(test.original))
	}
}
