package main

import (
	"fmt"

	"code.justin.tv/systems/plucker/digestor"
)

func addPageEventRules(eventRules digestor.EventRules, pages []Page, countries []Country) {
	for _, page := range pages {
		global := pageGlobalEvent(page)
		country := pageCountryEventy(page, countries)
		eventRules[benchmarkCompleteTransition] = append(eventRules[benchmarkCompleteTransition], global, country)
	}
}

func pageGlobalEvent(page Page) *digestor.EventConfig {
	return &digestor.EventConfig{
		StatType:   "timer",
		ValueField: "time_from_fetch",
		Alias:      fmt.Sprintf("page_load.%s.global", page.GraphiteAlias()),
		FilterConfig: digestor.FilterConfig{
			Equal: map[string][]string{
				"is_app_launch":   []string{"true"},
				"lost_visibility": []string{"false"},
				"destination":     []string{page.Destination},
			},
		},
	}
}

func pageCountryEventy(page Page, countries []Country) *digestor.EventConfig {
	return &digestor.EventConfig{
		StatType:   "timer",
		ValueField: "time_from_fetch",
		Alias:      fmt.Sprintf("page_load.%s.{{.country}}", page.GraphiteAlias()),
		FilterConfig: digestor.FilterConfig{
			Equal: map[string][]string{
				"country":         CountryCodes(countries),
				"is_app_launch":   []string{"true"},
				"lost_visibility": []string{"false"},
				"destination":     []string{page.Destination},
			},
		},
	}
}
