package main

import (
	"fmt"
	"regexp"
	"strings"
)

const (
	krakenPlaceholder      = "kraken"
	krakenPlaceholderRegex = "(kraken|v[0-9])"
	fieldPlaceholder       = "FIELD"
	fieldPlaceholderRegex  = "[0-9a-zA-Z_-]+"
	terminateRegex         = "(\\?|$)"
)

func urlRegexPattern(hostname, path string, terminate bool) string {
	unterminated := fmt.Sprintf("^https://%s%s",
		regexp.QuoteMeta(hostname),
		regexSupportKrakenVersions(regexReplaceFieldPlaceholders(regexp.QuoteMeta(path))))

	if terminate {
		return unterminated + terminateRegex
	}
	return unterminated
}

func regexSupportKrakenVersions(str string) string {
	return strings.Replace(str, krakenPlaceholder, krakenPlaceholderRegex, -1)
}

func regexReplaceFieldPlaceholders(str string) string {
	return strings.Replace(str, fieldPlaceholder, fieldPlaceholderRegex, -1)
}
