package main

type Page struct {
	Hostname    string
	Destination string
}

func (p Page) GraphiteAlias() string {
	return graphiteSafeString(p.Hostname) + "." + graphiteSafeString(p.Destination)
}

type APIRequest struct {
	Hostname string
	Path     string
}

func (r APIRequest) GraphiteAlias() string {
	return graphiteSafeString(r.Hostname) + "." + graphiteSafeString(r.Path[1:])
}

type CDNRequest struct {
	Hostname string
	Path     string
}

func (r CDNRequest) GraphiteAlias() string {
	return graphiteSafeString(r.Hostname) + "." + graphiteSafeString(r.Path[1:])
}

type DNSRequest struct {
	Hostname string
}

func (r DNSRequest) GraphiteAlias() string {
	return graphiteSafeString(r.Hostname)
}

type Country struct {
	Code string
}

func CountryCodes(countries []Country) []string {
	codes := make([]string, 0, len(countries))
	for _, country := range countries {
		codes = append(codes, country.Code)
	}
	return codes
}
