package digestor

// import "code.justin.tv/systems/plucker/spade"

// Config options for collector
type Config struct {
	// EventList of event names to whitelist, and their corresponding
	// columns to aggregate and collect metrics for.
	// []string map to spade.SchemaColumn.OutboundName
	EventRules EventRules `toml:"events"`
	// StatsD host to send counters to
	Statsd         string `toml:"statsd_host"`
	EventSource    string `toml:"event_source"`
	GraphiteBucket string `toml:"graphite_bucket"`
}

// EventRules maps event names to multiple configurations
type EventRules map[string][]*EventConfig

// EventConfig helps map Spade schema columns to statistic metadata.
// Each attribute is represented by a spade.Schema.OutboundName.
type EventConfig struct {
	// If this is a gauge, counter, set, timer
	StatType string `toml:"stat_type"`

	// If a counter, which field to increment on (or always inc by 1 if unset)
	// If a gauge, timer, or set, which field to base the stat value on
	ValueField string `toml:"value_field,omitempty"`

	// If set, will use this string as a base event name instead of how it
	// is named in Spade
	Alias string `toml:"alias,omitempty"`

	// If set, filters the event based on the provided configuration
	FilterConfig FilterConfig `toml:"filter,omitempty"`

	// Only for timer. If set, will multiply value field's value by the multiplier
	Multiplier int `toml:"value_multiplier,omitzero"`
}

// FilterConfig contains available methods in which a user can filter Spade
// events, such as by value or with a regex.
type FilterConfig struct {
	Equal map[string][]string `toml:"equal,omitempty"`
	Regex map[string][]string `toml:"regex,omitempty"`
}

// DefaultConfig options to use
func DefaultConfig() *Config {
	return &Config{
		// Map from a name of an event to how we want to deal with it
		EventRules:     map[string][]*EventConfig{},
		Statsd:         "127.0.0.1:8125",
		GraphiteBucket: "",
	}
}
