package digestor

import (
	"regexp"

	log "github.com/Sirupsen/logrus"
)

func valueMatchesExactly(value string, validValues []string) bool {
	for _, validValue := range validValues {
		if validValue == value {
			return true
		}
	}
	return false
}

func valueMatchesPattern(value string, validPatterns []string) bool {
	for _, validPattern := range validPatterns {
		match, err := regexp.MatchString(validPattern, value)
		if err != nil {
			log.Warnf("Unexpected error while running regex %q on value %q: %v", validPattern, value, err)
		} else if match {
			return true
		}
	}
	return false
}
