package kinesis

// Config holds configuration information for a Kinesis consumer
type Config struct {
	StreamName     string `toml:"stream_name"`
	UseLocal       bool   `toml:"use_local"`
	StatsdEndpoint string `toml:"statsd_endpoint"`
	RoleARN        string `toml:"role_arn"`
	// This is for creating a statsd prefix for internal statistics
	Environment string `toml:"environment"`
}

// DefaultConfig Returns the default config for a Kinesis worker
func DefaultConfig() *Config {
	return &Config{
		UseLocal:    false,
		Environment: "development",
	}
}
