package kinesis

import "encoding/json"

// Event is used to unmarshal spade events from a KinesisRecord.
type Event struct {
	Name   string
	Fields map[string]string
}

// NewEventsFromPayload turns a kinesis record payload
// and unmarshals it into an array of event structs
func NewEventsFromPayload(b []byte) ([]*Event, error) {
	var events []*Event
	err := json.Unmarshal(b, &events)
	if err != nil {
		return nil, err
	}
	return events, nil
}
