// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplacemetering_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/marketplacemetering"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleMarketplaceMetering_BatchMeterUsage() {
	sess := session.Must(session.NewSession())

	svc := marketplacemetering.New(sess)

	params := &marketplacemetering.BatchMeterUsageInput{
		ProductCode: aws.String("ProductCode"), // Required
		UsageRecords: []*marketplacemetering.UsageRecord{ // Required
			{ // Required
				CustomerIdentifier: aws.String("CustomerIdentifier"), // Required
				Dimension:          aws.String("UsageDimension"),     // Required
				Quantity:           aws.Int64(1),                     // Required
				Timestamp:          aws.Time(time.Now()),             // Required
			},
			// More values...
		},
	}
	resp, err := svc.BatchMeterUsage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMarketplaceMetering_MeterUsage() {
	sess := session.Must(session.NewSession())

	svc := marketplacemetering.New(sess)

	params := &marketplacemetering.MeterUsageInput{
		DryRun:         aws.Bool(true),               // Required
		ProductCode:    aws.String("ProductCode"),    // Required
		Timestamp:      aws.Time(time.Now()),         // Required
		UsageDimension: aws.String("UsageDimension"), // Required
		UsageQuantity:  aws.Int64(1),                 // Required
	}
	resp, err := svc.MeterUsage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMarketplaceMetering_ResolveCustomer() {
	sess := session.Must(session.NewSession())

	svc := marketplacemetering.New(sess)

	params := &marketplacemetering.ResolveCustomerInput{
		RegistrationToken: aws.String("NonEmptyString"), // Required
	}
	resp, err := svc.ResolveCustomer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
