// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/mturk"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleMTurk_AcceptQualificationRequest() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.AcceptQualificationRequestInput{
		QualificationRequestId: aws.String("String"), // Required
		IntegerValue:           aws.Int64(1),
	}
	resp, err := svc.AcceptQualificationRequest(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ApproveAssignment() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ApproveAssignmentInput{
		AssignmentId:      aws.String("EntityId"), // Required
		OverrideRejection: aws.Bool(true),
		RequesterFeedback: aws.String("String"),
	}
	resp, err := svc.ApproveAssignment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_AssociateQualificationWithWorker() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.AssociateQualificationWithWorkerInput{
		QualificationTypeId: aws.String("EntityId"),   // Required
		WorkerId:            aws.String("CustomerId"), // Required
		IntegerValue:        aws.Int64(1),
		SendNotification:    aws.Bool(true),
	}
	resp, err := svc.AssociateQualificationWithWorker(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_CreateAdditionalAssignmentsForHIT() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.CreateAdditionalAssignmentsForHITInput{
		HITId: aws.String("EntityId"), // Required
		NumberOfAdditionalAssignments: aws.Int64(1),
		UniqueRequestToken:            aws.String("IdempotencyToken"),
	}
	resp, err := svc.CreateAdditionalAssignmentsForHIT(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_CreateHIT() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.CreateHITInput{
		AssignmentDurationInSeconds: aws.Int64(1),               // Required
		Description:                 aws.String("String"),       // Required
		LifetimeInSeconds:           aws.Int64(1),               // Required
		Reward:                      aws.String("NumericValue"), // Required
		Title:                       aws.String("String"),       // Required
		AssignmentReviewPolicy: &mturk.ReviewPolicy{
			Parameters: []*mturk.PolicyParameter{
				{ // Required
					Key: aws.String("String"),
					MapEntries: []*mturk.ParameterMapEntry{
						{ // Required
							Key: aws.String("String"),
							Values: []*string{
								aws.String("String"), // Required
								// More values...
							},
						},
						// More values...
					},
					Values: []*string{
						aws.String("String"), // Required
						// More values...
					},
				},
				// More values...
			},
			PolicyName: aws.String("String"),
		},
		AutoApprovalDelayInSeconds: aws.Int64(1),
		HITLayoutId:                aws.String("EntityId"),
		HITLayoutParameters: []*mturk.HITLayoutParameter{
			{ // Required
				Name:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		HITReviewPolicy: &mturk.ReviewPolicy{
			Parameters: []*mturk.PolicyParameter{
				{ // Required
					Key: aws.String("String"),
					MapEntries: []*mturk.ParameterMapEntry{
						{ // Required
							Key: aws.String("String"),
							Values: []*string{
								aws.String("String"), // Required
								// More values...
							},
						},
						// More values...
					},
					Values: []*string{
						aws.String("String"), // Required
						// More values...
					},
				},
				// More values...
			},
			PolicyName: aws.String("String"),
		},
		Keywords:       aws.String("String"),
		MaxAssignments: aws.Int64(1),
		QualificationRequirements: []*mturk.QualificationRequirement{
			{ // Required
				Comparator:          aws.String("Comparator"), // Required
				QualificationTypeId: aws.String("String"),     // Required
				IntegerValues: []*int64{
					aws.Int64(1), // Required
					// More values...
				},
				LocaleValues: []*mturk.Locale{
					{ // Required
						Country:     aws.String("CountryParameters"), // Required
						Subdivision: aws.String("CountryParameters"),
					},
					// More values...
				},
				RequiredToPreview: aws.Bool(true),
			},
			// More values...
		},
		Question:            aws.String("String"),
		RequesterAnnotation: aws.String("String"),
		UniqueRequestToken:  aws.String("IdempotencyToken"),
	}
	resp, err := svc.CreateHIT(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_CreateHITType() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.CreateHITTypeInput{
		AssignmentDurationInSeconds: aws.Int64(1),               // Required
		Description:                 aws.String("String"),       // Required
		Reward:                      aws.String("NumericValue"), // Required
		Title:                       aws.String("String"),       // Required
		AutoApprovalDelayInSeconds: aws.Int64(1),
		Keywords:                   aws.String("String"),
		QualificationRequirements: []*mturk.QualificationRequirement{
			{ // Required
				Comparator:          aws.String("Comparator"), // Required
				QualificationTypeId: aws.String("String"),     // Required
				IntegerValues: []*int64{
					aws.Int64(1), // Required
					// More values...
				},
				LocaleValues: []*mturk.Locale{
					{ // Required
						Country:     aws.String("CountryParameters"), // Required
						Subdivision: aws.String("CountryParameters"),
					},
					// More values...
				},
				RequiredToPreview: aws.Bool(true),
			},
			// More values...
		},
	}
	resp, err := svc.CreateHITType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_CreateHITWithHITType() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.CreateHITWithHITTypeInput{
		HITTypeId:         aws.String("EntityId"), // Required
		LifetimeInSeconds: aws.Int64(1),           // Required
		AssignmentReviewPolicy: &mturk.ReviewPolicy{
			Parameters: []*mturk.PolicyParameter{
				{ // Required
					Key: aws.String("String"),
					MapEntries: []*mturk.ParameterMapEntry{
						{ // Required
							Key: aws.String("String"),
							Values: []*string{
								aws.String("String"), // Required
								// More values...
							},
						},
						// More values...
					},
					Values: []*string{
						aws.String("String"), // Required
						// More values...
					},
				},
				// More values...
			},
			PolicyName: aws.String("String"),
		},
		HITLayoutId: aws.String("EntityId"),
		HITLayoutParameters: []*mturk.HITLayoutParameter{
			{ // Required
				Name:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		HITReviewPolicy: &mturk.ReviewPolicy{
			Parameters: []*mturk.PolicyParameter{
				{ // Required
					Key: aws.String("String"),
					MapEntries: []*mturk.ParameterMapEntry{
						{ // Required
							Key: aws.String("String"),
							Values: []*string{
								aws.String("String"), // Required
								// More values...
							},
						},
						// More values...
					},
					Values: []*string{
						aws.String("String"), // Required
						// More values...
					},
				},
				// More values...
			},
			PolicyName: aws.String("String"),
		},
		MaxAssignments:      aws.Int64(1),
		Question:            aws.String("String"),
		RequesterAnnotation: aws.String("String"),
		UniqueRequestToken:  aws.String("IdempotencyToken"),
	}
	resp, err := svc.CreateHITWithHITType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_CreateQualificationType() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.CreateQualificationTypeInput{
		Description: aws.String("String"), // Required
		Name:        aws.String("String"), // Required
		QualificationTypeStatus: aws.String("QualificationTypeStatus"), // Required
		AnswerKey:               aws.String("String"),
		AutoGranted:             aws.Bool(true),
		AutoGrantedValue:        aws.Int64(1),
		Keywords:                aws.String("String"),
		RetryDelayInSeconds:     aws.Int64(1),
		Test:                    aws.String("String"),
		TestDurationInSeconds: aws.Int64(1),
	}
	resp, err := svc.CreateQualificationType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_CreateWorkerBlock() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.CreateWorkerBlockInput{
		Reason:   aws.String("String"),     // Required
		WorkerId: aws.String("CustomerId"), // Required
	}
	resp, err := svc.CreateWorkerBlock(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_DeleteHIT() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.DeleteHITInput{
		HITId: aws.String("EntityId"), // Required
	}
	resp, err := svc.DeleteHIT(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_DeleteQualificationType() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.DeleteQualificationTypeInput{
		QualificationTypeId: aws.String("EntityId"), // Required
	}
	resp, err := svc.DeleteQualificationType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_DeleteWorkerBlock() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.DeleteWorkerBlockInput{
		WorkerId: aws.String("CustomerId"), // Required
		Reason:   aws.String("String"),
	}
	resp, err := svc.DeleteWorkerBlock(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_DisassociateQualificationFromWorker() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.DisassociateQualificationFromWorkerInput{
		QualificationTypeId: aws.String("EntityId"),   // Required
		WorkerId:            aws.String("CustomerId"), // Required
		Reason:              aws.String("String"),
	}
	resp, err := svc.DisassociateQualificationFromWorker(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_GetAccountBalance() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	var params *mturk.GetAccountBalanceInput
	resp, err := svc.GetAccountBalance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_GetAssignment() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.GetAssignmentInput{
		AssignmentId: aws.String("EntityId"), // Required
	}
	resp, err := svc.GetAssignment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_GetFileUploadURL() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.GetFileUploadURLInput{
		AssignmentId:       aws.String("EntityId"), // Required
		QuestionIdentifier: aws.String("String"),   // Required
	}
	resp, err := svc.GetFileUploadURL(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_GetHIT() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.GetHITInput{
		HITId: aws.String("EntityId"), // Required
	}
	resp, err := svc.GetHIT(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_GetQualificationScore() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.GetQualificationScoreInput{
		QualificationTypeId: aws.String("EntityId"),   // Required
		WorkerId:            aws.String("CustomerId"), // Required
	}
	resp, err := svc.GetQualificationScore(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_GetQualificationType() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.GetQualificationTypeInput{
		QualificationTypeId: aws.String("EntityId"), // Required
	}
	resp, err := svc.GetQualificationType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ListAssignmentsForHIT() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ListAssignmentsForHITInput{
		HITId: aws.String("EntityId"), // Required
		AssignmentStatuses: []*string{
			aws.String("AssignmentStatus"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
	}
	resp, err := svc.ListAssignmentsForHIT(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ListBonusPayments() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ListBonusPaymentsInput{
		AssignmentId: aws.String("EntityId"),
		HITId:        aws.String("EntityId"),
		MaxResults:   aws.Int64(1),
		NextToken:    aws.String("PaginationToken"),
	}
	resp, err := svc.ListBonusPayments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ListHITs() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ListHITsInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
	}
	resp, err := svc.ListHITs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ListHITsForQualificationType() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ListHITsForQualificationTypeInput{
		QualificationTypeId: aws.String("EntityId"), // Required
		MaxResults:          aws.Int64(1),
		NextToken:           aws.String("PaginationToken"),
	}
	resp, err := svc.ListHITsForQualificationType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ListQualificationRequests() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ListQualificationRequestsInput{
		MaxResults:          aws.Int64(1),
		NextToken:           aws.String("PaginationToken"),
		QualificationTypeId: aws.String("EntityId"),
	}
	resp, err := svc.ListQualificationRequests(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ListQualificationTypes() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ListQualificationTypesInput{
		MustBeRequestable:   aws.Bool(true), // Required
		MaxResults:          aws.Int64(1),
		MustBeOwnedByCaller: aws.Bool(true),
		NextToken:           aws.String("PaginationToken"),
		Query:               aws.String("String"),
	}
	resp, err := svc.ListQualificationTypes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ListReviewPolicyResultsForHIT() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ListReviewPolicyResultsForHITInput{
		HITId:      aws.String("EntityId"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
		PolicyLevels: []*string{
			aws.String("ReviewPolicyLevel"), // Required
			// More values...
		},
		RetrieveActions: aws.Bool(true),
		RetrieveResults: aws.Bool(true),
	}
	resp, err := svc.ListReviewPolicyResultsForHIT(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ListReviewableHITs() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ListReviewableHITsInput{
		HITTypeId:  aws.String("EntityId"),
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
		Status:     aws.String("ReviewableHITStatus"),
	}
	resp, err := svc.ListReviewableHITs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ListWorkerBlocks() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ListWorkerBlocksInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
	}
	resp, err := svc.ListWorkerBlocks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_ListWorkersWithQualificationType() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.ListWorkersWithQualificationTypeInput{
		QualificationTypeId: aws.String("EntityId"), // Required
		MaxResults:          aws.Int64(1),
		NextToken:           aws.String("PaginationToken"),
		Status:              aws.String("QualificationStatus"),
	}
	resp, err := svc.ListWorkersWithQualificationType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_NotifyWorkers() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.NotifyWorkersInput{
		MessageText: aws.String("String"), // Required
		Subject:     aws.String("String"), // Required
		WorkerIds: []*string{ // Required
			aws.String("CustomerId"), // Required
			// More values...
		},
	}
	resp, err := svc.NotifyWorkers(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_RejectAssignment() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.RejectAssignmentInput{
		AssignmentId:      aws.String("EntityId"), // Required
		RequesterFeedback: aws.String("String"),
	}
	resp, err := svc.RejectAssignment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_RejectQualificationRequest() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.RejectQualificationRequestInput{
		QualificationRequestId: aws.String("String"), // Required
		Reason:                 aws.String("String"),
	}
	resp, err := svc.RejectQualificationRequest(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_SendBonus() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.SendBonusInput{
		AssignmentId:       aws.String("EntityId"),     // Required
		BonusAmount:        aws.String("NumericValue"), // Required
		WorkerId:           aws.String("CustomerId"),   // Required
		Reason:             aws.String("String"),
		UniqueRequestToken: aws.String("IdempotencyToken"),
	}
	resp, err := svc.SendBonus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_SendTestEventNotification() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.SendTestEventNotificationInput{
		Notification: &mturk.NotificationSpecification{ // Required
			Destination: aws.String("String"),                // Required
			Transport:   aws.String("NotificationTransport"), // Required
			EventTypes: []*string{
				aws.String("EventType"), // Required
				// More values...
			},
			Version: aws.String("String"),
		},
		TestEventType: aws.String("EventType"), // Required
	}
	resp, err := svc.SendTestEventNotification(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_UpdateExpirationForHIT() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.UpdateExpirationForHITInput{
		HITId:    aws.String("EntityId"), // Required
		ExpireAt: aws.Time(time.Now()),
	}
	resp, err := svc.UpdateExpirationForHIT(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_UpdateHITReviewStatus() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.UpdateHITReviewStatusInput{
		HITId:  aws.String("EntityId"), // Required
		Revert: aws.Bool(true),
	}
	resp, err := svc.UpdateHITReviewStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_UpdateHITTypeOfHIT() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.UpdateHITTypeOfHITInput{
		HITId:     aws.String("EntityId"), // Required
		HITTypeId: aws.String("EntityId"), // Required
	}
	resp, err := svc.UpdateHITTypeOfHIT(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_UpdateNotificationSettings() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.UpdateNotificationSettingsInput{
		HITTypeId: aws.String("EntityId"), // Required
		Active:    aws.Bool(true),
		Notification: &mturk.NotificationSpecification{
			Destination: aws.String("String"),                // Required
			Transport:   aws.String("NotificationTransport"), // Required
			EventTypes: []*string{
				aws.String("EventType"), // Required
				// More values...
			},
			Version: aws.String("String"),
		},
	}
	resp, err := svc.UpdateNotificationSettings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleMTurk_UpdateQualificationType() {
	sess := session.Must(session.NewSession())

	svc := mturk.New(sess)

	params := &mturk.UpdateQualificationTypeInput{
		QualificationTypeId:     aws.String("EntityId"), // Required
		AnswerKey:               aws.String("String"),
		AutoGranted:             aws.Bool(true),
		AutoGrantedValue:        aws.Int64(1),
		Description:             aws.String("String"),
		QualificationTypeStatus: aws.String("QualificationTypeStatus"),
		RetryDelayInSeconds:     aws.Int64(1),
		Test:                    aws.String("String"),
		TestDurationInSeconds: aws.Int64(1),
	}
	resp, err := svc.UpdateQualificationType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
