// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroupstaggingapi_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/resourcegroupstaggingapi"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleResourceGroupsTaggingAPI_GetResources() {
	sess := session.Must(session.NewSession())

	svc := resourcegroupstaggingapi.New(sess)

	params := &resourcegroupstaggingapi.GetResourcesInput{
		TagsPerPage:     aws.Int64(1), // Required
		PaginationToken: aws.String("PaginationToken"),
		ResourceTypeFilters: []*string{
			aws.String("AmazonResourceType"), // Required
			// More values...
		},
		TagFilters: []*resourcegroupstaggingapi.TagFilter{
			{ // Required
				Key: aws.String("TagKey"),
				Values: []*string{
					aws.String("TagValue"), // Required
					// More values...
				},
			},
			// More values...
		},
	}
	resp, err := svc.GetResources(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleResourceGroupsTaggingAPI_GetTagKeys() {
	sess := session.Must(session.NewSession())

	svc := resourcegroupstaggingapi.New(sess)

	params := &resourcegroupstaggingapi.GetTagKeysInput{
		PaginationToken: aws.String("PaginationToken"),
	}
	resp, err := svc.GetTagKeys(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleResourceGroupsTaggingAPI_GetTagValues() {
	sess := session.Must(session.NewSession())

	svc := resourcegroupstaggingapi.New(sess)

	params := &resourcegroupstaggingapi.GetTagValuesInput{
		Key:             aws.String("TagKey"), // Required
		PaginationToken: aws.String("PaginationToken"),
	}
	resp, err := svc.GetTagValues(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleResourceGroupsTaggingAPI_TagResources() {
	sess := session.Must(session.NewSession())

	svc := resourcegroupstaggingapi.New(sess)

	params := &resourcegroupstaggingapi.TagResourcesInput{
		ResourceARNList: []*string{ // Required
			aws.String("ResourceARN"), // Required
			// More values...
		},
		Tags: map[string]*string{ // Required
			"Key": aws.String("TagValue"), // Required
			// More values...
		},
	}
	resp, err := svc.TagResources(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleResourceGroupsTaggingAPI_UntagResources() {
	sess := session.Must(session.NewSession())

	svc := resourcegroupstaggingapi.New(sess)

	params := &resourcegroupstaggingapi.UntagResourcesInput{
		ResourceARNList: []*string{ // Required
			aws.String("ResourceARN"), // Required
			// More values...
		},
		TagKeys: []*string{ // Required
			aws.String("TagKey"), // Required
			// More values...
		},
	}
	resp, err := svc.UntagResources(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
