// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package shield provides a client for AWS Shield.
package shield

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateProtection = "CreateProtection"

// CreateProtectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateProtection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateProtection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateProtection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateProtectionRequest method.
//    req, resp := client.CreateProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection
func (c *Shield) CreateProtectionRequest(input *CreateProtectionInput) (req *request.Request, output *CreateProtectionOutput) {
	op := &request.Operation{
		Name:       opCreateProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProtectionInput{}
	}

	output = &CreateProtectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProtection API operation for AWS Shield.
//
// Enables AWS Shield Advanced for a specific AWS resource. The resource can
// be an Amazon CloudFront distribution, Elastic Load Balancing load balancer,
// or an Amazon Route 53 hosted zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Shield's
// API operation CreateProtection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Exception that indicates that a problem occurred with the service infrastructure.
//   You can retry the request.
//
//   * ErrCodeInvalidResourceException "InvalidResourceException"
//   Exception that indicates that the resource is invalid. You might not have
//   access to the resource, or the resource might not exist.
//
//   * ErrCodeInvalidOperationException "InvalidOperationException"
//   Exception that indicates that the operation would not cause any change to
//   occur.
//
//   * ErrCodeLimitsExceededException "LimitsExceededException"
//   Exception that indicates that the operation would exceed a limit.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   Exception indicating the specified resource already exists.
//
//   * ErrCodeOptimisticLockException "OptimisticLockException"
//   Exception that indicates that the protection state has been modified by another
//   client. You can retry the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception indicating the specified resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection
func (c *Shield) CreateProtection(input *CreateProtectionInput) (*CreateProtectionOutput, error) {
	req, out := c.CreateProtectionRequest(input)
	return out, req.Send()
}

// CreateProtectionWithContext is the same as CreateProtection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Shield) CreateProtectionWithContext(ctx aws.Context, input *CreateProtectionInput, opts ...request.Option) (*CreateProtectionOutput, error) {
	req, out := c.CreateProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscription = "CreateSubscription"

// CreateSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSubscription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSubscription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSubscriptionRequest method.
//    req, resp := client.CreateSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription
func (c *Shield) CreateSubscriptionRequest(input *CreateSubscriptionInput) (req *request.Request, output *CreateSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubscriptionInput{}
	}

	output = &CreateSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscription API operation for AWS Shield.
//
// Activates AWS Shield Advanced for an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Shield's
// API operation CreateSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Exception that indicates that a problem occurred with the service infrastructure.
//   You can retry the request.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   Exception indicating the specified resource already exists.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription
func (c *Shield) CreateSubscription(input *CreateSubscriptionInput) (*CreateSubscriptionOutput, error) {
	req, out := c.CreateSubscriptionRequest(input)
	return out, req.Send()
}

// CreateSubscriptionWithContext is the same as CreateSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Shield) CreateSubscriptionWithContext(ctx aws.Context, input *CreateSubscriptionInput, opts ...request.Option) (*CreateSubscriptionOutput, error) {
	req, out := c.CreateSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProtection = "DeleteProtection"

// DeleteProtectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProtection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteProtection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteProtection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteProtectionRequest method.
//    req, resp := client.DeleteProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtection
func (c *Shield) DeleteProtectionRequest(input *DeleteProtectionInput) (req *request.Request, output *DeleteProtectionOutput) {
	op := &request.Operation{
		Name:       opDeleteProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProtectionInput{}
	}

	output = &DeleteProtectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProtection API operation for AWS Shield.
//
// Deletes an AWS Shield Advanced Protection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Shield's
// API operation DeleteProtection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Exception that indicates that a problem occurred with the service infrastructure.
//   You can retry the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception indicating the specified resource does not exist.
//
//   * ErrCodeOptimisticLockException "OptimisticLockException"
//   Exception that indicates that the protection state has been modified by another
//   client. You can retry the request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtection
func (c *Shield) DeleteProtection(input *DeleteProtectionInput) (*DeleteProtectionOutput, error) {
	req, out := c.DeleteProtectionRequest(input)
	return out, req.Send()
}

// DeleteProtectionWithContext is the same as DeleteProtection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Shield) DeleteProtectionWithContext(ctx aws.Context, input *DeleteProtectionInput, opts ...request.Option) (*DeleteProtectionOutput, error) {
	req, out := c.DeleteProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscription = "DeleteSubscription"

// DeleteSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSubscription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSubscription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSubscriptionRequest method.
//    req, resp := client.DeleteSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteSubscription
func (c *Shield) DeleteSubscriptionRequest(input *DeleteSubscriptionInput) (req *request.Request, output *DeleteSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubscriptionInput{}
	}

	output = &DeleteSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSubscription API operation for AWS Shield.
//
// Removes AWS Shield Advanced from an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Shield's
// API operation DeleteSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Exception that indicates that a problem occurred with the service infrastructure.
//   You can retry the request.
//
//   * ErrCodeLockedSubscriptionException "LockedSubscriptionException"
//   Exception that indicates that the subscription has been modified by another
//   client. You can retry the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception indicating the specified resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteSubscription
func (c *Shield) DeleteSubscription(input *DeleteSubscriptionInput) (*DeleteSubscriptionOutput, error) {
	req, out := c.DeleteSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteSubscriptionWithContext is the same as DeleteSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Shield) DeleteSubscriptionWithContext(ctx aws.Context, input *DeleteSubscriptionInput, opts ...request.Option) (*DeleteSubscriptionOutput, error) {
	req, out := c.DeleteSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAttack = "DescribeAttack"

// DescribeAttackRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAttack operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAttack for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAttack method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAttackRequest method.
//    req, resp := client.DescribeAttackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttack
func (c *Shield) DescribeAttackRequest(input *DescribeAttackInput) (req *request.Request, output *DescribeAttackOutput) {
	op := &request.Operation{
		Name:       opDescribeAttack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAttackInput{}
	}

	output = &DescribeAttackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAttack API operation for AWS Shield.
//
// Describes the details of a DDoS attack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Shield's
// API operation DescribeAttack for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Exception that indicates that a problem occurred with the service infrastructure.
//   You can retry the request.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Exception that indicates that the parameters passed to the API are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttack
func (c *Shield) DescribeAttack(input *DescribeAttackInput) (*DescribeAttackOutput, error) {
	req, out := c.DescribeAttackRequest(input)
	return out, req.Send()
}

// DescribeAttackWithContext is the same as DescribeAttack with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAttack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Shield) DescribeAttackWithContext(ctx aws.Context, input *DescribeAttackInput, opts ...request.Option) (*DescribeAttackOutput, error) {
	req, out := c.DescribeAttackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProtection = "DescribeProtection"

// DescribeProtectionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProtection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeProtection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeProtection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeProtectionRequest method.
//    req, resp := client.DescribeProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection
func (c *Shield) DescribeProtectionRequest(input *DescribeProtectionInput) (req *request.Request, output *DescribeProtectionOutput) {
	op := &request.Operation{
		Name:       opDescribeProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProtectionInput{}
	}

	output = &DescribeProtectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProtection API operation for AWS Shield.
//
// Lists the details of a Protection object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Shield's
// API operation DescribeProtection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Exception that indicates that a problem occurred with the service infrastructure.
//   You can retry the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception indicating the specified resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection
func (c *Shield) DescribeProtection(input *DescribeProtectionInput) (*DescribeProtectionOutput, error) {
	req, out := c.DescribeProtectionRequest(input)
	return out, req.Send()
}

// DescribeProtectionWithContext is the same as DescribeProtection with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Shield) DescribeProtectionWithContext(ctx aws.Context, input *DescribeProtectionInput, opts ...request.Option) (*DescribeProtectionOutput, error) {
	req, out := c.DescribeProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSubscription = "DescribeSubscription"

// DescribeSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSubscription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSubscription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSubscription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSubscriptionRequest method.
//    req, resp := client.DescribeSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription
func (c *Shield) DescribeSubscriptionRequest(input *DescribeSubscriptionInput) (req *request.Request, output *DescribeSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDescribeSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSubscriptionInput{}
	}

	output = &DescribeSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSubscription API operation for AWS Shield.
//
// Provides details about the AWS Shield Advanced subscription for an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Shield's
// API operation DescribeSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Exception that indicates that a problem occurred with the service infrastructure.
//   You can retry the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception indicating the specified resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription
func (c *Shield) DescribeSubscription(input *DescribeSubscriptionInput) (*DescribeSubscriptionOutput, error) {
	req, out := c.DescribeSubscriptionRequest(input)
	return out, req.Send()
}

// DescribeSubscriptionWithContext is the same as DescribeSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Shield) DescribeSubscriptionWithContext(ctx aws.Context, input *DescribeSubscriptionInput, opts ...request.Option) (*DescribeSubscriptionOutput, error) {
	req, out := c.DescribeSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAttacks = "ListAttacks"

// ListAttacksRequest generates a "aws/request.Request" representing the
// client's request for the ListAttacks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAttacks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAttacks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAttacksRequest method.
//    req, resp := client.ListAttacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks
func (c *Shield) ListAttacksRequest(input *ListAttacksInput) (req *request.Request, output *ListAttacksOutput) {
	op := &request.Operation{
		Name:       opListAttacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAttacksInput{}
	}

	output = &ListAttacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttacks API operation for AWS Shield.
//
// Returns all ongoing DDoS attacks or all DDoS attacks during a specified time
// period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Shield's
// API operation ListAttacks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Exception that indicates that a problem occurred with the service infrastructure.
//   You can retry the request.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Exception that indicates that the parameters passed to the API are invalid.
//
//   * ErrCodeInvalidOperationException "InvalidOperationException"
//   Exception that indicates that the operation would not cause any change to
//   occur.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks
func (c *Shield) ListAttacks(input *ListAttacksInput) (*ListAttacksOutput, error) {
	req, out := c.ListAttacksRequest(input)
	return out, req.Send()
}

// ListAttacksWithContext is the same as ListAttacks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Shield) ListAttacksWithContext(ctx aws.Context, input *ListAttacksInput, opts ...request.Option) (*ListAttacksOutput, error) {
	req, out := c.ListAttacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProtections = "ListProtections"

// ListProtectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListProtections operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListProtections for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListProtections method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListProtectionsRequest method.
//    req, resp := client.ListProtectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections
func (c *Shield) ListProtectionsRequest(input *ListProtectionsInput) (req *request.Request, output *ListProtectionsOutput) {
	op := &request.Operation{
		Name:       opListProtections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListProtectionsInput{}
	}

	output = &ListProtectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProtections API operation for AWS Shield.
//
// Lists all Protection objects for the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Shield's
// API operation ListProtections for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Exception that indicates that a problem occurred with the service infrastructure.
//   You can retry the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception indicating the specified resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections
func (c *Shield) ListProtections(input *ListProtectionsInput) (*ListProtectionsOutput, error) {
	req, out := c.ListProtectionsRequest(input)
	return out, req.Send()
}

// ListProtectionsWithContext is the same as ListProtections with the addition of
// the ability to pass a context and additional request options.
//
// See ListProtections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Shield) ListProtectionsWithContext(ctx aws.Context, input *ListProtectionsInput, opts ...request.Option) (*ListProtectionsOutput, error) {
	req, out := c.ListProtectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The details of a DDoS attack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AttackDetail
type AttackDetail struct {
	_ struct{} `type:"structure"`

	// List of counters that describe the attack for the specified time period.
	AttackCounters []*SummarizedCounter `type:"list"`

	// The unique identifier (ID) of the attack.
	AttackId *string `min:"1" type:"string"`

	// The time the attack ended, in the format 2016-12-16T13:50Z.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// List of mitigation actions taken for the attack.
	Mitigations []*Mitigation `type:"list"`

	// The ARN (Amazon Resource Name) of the resource that was attacked.
	ResourceArn *string `min:"1" type:"string"`

	// The time the attack started, in the format 2016-12-16T13:50Z.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// If applicable, additional detail about the resource being attacked, for example,
	// IP address or URL.
	SubResources []*SubResourceSummary `type:"list"`
}

// String returns the string representation
func (s AttackDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttackDetail) GoString() string {
	return s.String()
}

// SetAttackCounters sets the AttackCounters field's value.
func (s *AttackDetail) SetAttackCounters(v []*SummarizedCounter) *AttackDetail {
	s.AttackCounters = v
	return s
}

// SetAttackId sets the AttackId field's value.
func (s *AttackDetail) SetAttackId(v string) *AttackDetail {
	s.AttackId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AttackDetail) SetEndTime(v time.Time) *AttackDetail {
	s.EndTime = &v
	return s
}

// SetMitigations sets the Mitigations field's value.
func (s *AttackDetail) SetMitigations(v []*Mitigation) *AttackDetail {
	s.Mitigations = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AttackDetail) SetResourceArn(v string) *AttackDetail {
	s.ResourceArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AttackDetail) SetStartTime(v time.Time) *AttackDetail {
	s.StartTime = &v
	return s
}

// SetSubResources sets the SubResources field's value.
func (s *AttackDetail) SetSubResources(v []*SubResourceSummary) *AttackDetail {
	s.SubResources = v
	return s
}

// Summarizes all DDoS attacks for a specified time period.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AttackSummary
type AttackSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the attack.
	AttackId *string `type:"string"`

	// The list of attacks for a specified time period.
	AttackVectors []*AttackVectorDescription `type:"list"`

	// The end time of the attack, in the format 2016-12-16T13:50Z.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ARN (Amazon Resource Name) of the resource that was attacked.
	ResourceArn *string `type:"string"`

	// The start time of the attack, in the format 2016-12-16T13:50Z.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s AttackSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttackSummary) GoString() string {
	return s.String()
}

// SetAttackId sets the AttackId field's value.
func (s *AttackSummary) SetAttackId(v string) *AttackSummary {
	s.AttackId = &v
	return s
}

// SetAttackVectors sets the AttackVectors field's value.
func (s *AttackSummary) SetAttackVectors(v []*AttackVectorDescription) *AttackSummary {
	s.AttackVectors = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AttackSummary) SetEndTime(v time.Time) *AttackSummary {
	s.EndTime = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AttackSummary) SetResourceArn(v string) *AttackSummary {
	s.ResourceArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AttackSummary) SetStartTime(v time.Time) *AttackSummary {
	s.StartTime = &v
	return s
}

// Describes the attack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AttackVectorDescription
type AttackVectorDescription struct {
	_ struct{} `type:"structure"`

	// The attack type, for example, SNMP reflection or SYN flood.
	//
	// VectorType is a required field
	VectorType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttackVectorDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttackVectorDescription) GoString() string {
	return s.String()
}

// SetVectorType sets the VectorType field's value.
func (s *AttackVectorDescription) SetVectorType(v string) *AttackVectorDescription {
	s.VectorType = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtectionRequest
type CreateProtectionInput struct {
	_ struct{} `type:"structure"`

	// Friendly name for the Protection you are creating.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The ARN (Amazon Resource Name) of the resource to be protected.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProtectionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateProtectionInput) SetName(v string) *CreateProtectionInput {
	s.Name = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateProtectionInput) SetResourceArn(v string) *CreateProtectionInput {
	s.ResourceArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtectionResponse
type CreateProtectionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) for the Protection object that is created.
	ProtectionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProtectionOutput) GoString() string {
	return s.String()
}

// SetProtectionId sets the ProtectionId field's value.
func (s *CreateProtectionOutput) SetProtectionId(v string) *CreateProtectionOutput {
	s.ProtectionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscriptionRequest
type CreateSubscriptionInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriptionInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscriptionResponse
type CreateSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriptionOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtectionRequest
type DeleteProtectionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) for the Protection object to be deleted.
	//
	// ProtectionId is a required field
	ProtectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProtectionInput"}
	if s.ProtectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtectionId"))
	}
	if s.ProtectionId != nil && len(*s.ProtectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProtectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProtectionId sets the ProtectionId field's value.
func (s *DeleteProtectionInput) SetProtectionId(v string) *DeleteProtectionInput {
	s.ProtectionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtectionResponse
type DeleteProtectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProtectionOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteSubscriptionRequest
type DeleteSubscriptionInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubscriptionInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteSubscriptionResponse
type DeleteSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubscriptionOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttackRequest
type DescribeAttackInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) for the attack that to be described.
	//
	// AttackId is a required field
	AttackId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAttackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAttackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAttackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAttackInput"}
	if s.AttackId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttackId"))
	}
	if s.AttackId != nil && len(*s.AttackId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttackId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttackId sets the AttackId field's value.
func (s *DescribeAttackInput) SetAttackId(v string) *DescribeAttackInput {
	s.AttackId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttackResponse
type DescribeAttackOutput struct {
	_ struct{} `type:"structure"`

	// The attack that is described.
	Attack *AttackDetail `type:"structure"`
}

// String returns the string representation
func (s DescribeAttackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAttackOutput) GoString() string {
	return s.String()
}

// SetAttack sets the Attack field's value.
func (s *DescribeAttackOutput) SetAttack(v *AttackDetail) *DescribeAttackOutput {
	s.Attack = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtectionRequest
type DescribeProtectionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) for the Protection object that is described.
	//
	// ProtectionId is a required field
	ProtectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProtectionInput"}
	if s.ProtectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtectionId"))
	}
	if s.ProtectionId != nil && len(*s.ProtectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProtectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProtectionId sets the ProtectionId field's value.
func (s *DescribeProtectionInput) SetProtectionId(v string) *DescribeProtectionInput {
	s.ProtectionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtectionResponse
type DescribeProtectionOutput struct {
	_ struct{} `type:"structure"`

	// The Protection object that is described.
	Protection *Protection `type:"structure"`
}

// String returns the string representation
func (s DescribeProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProtectionOutput) GoString() string {
	return s.String()
}

// SetProtection sets the Protection field's value.
func (s *DescribeProtectionOutput) SetProtection(v *Protection) *DescribeProtectionOutput {
	s.Protection = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscriptionRequest
type DescribeSubscriptionInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubscriptionInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscriptionResponse
type DescribeSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The AWS Shield Advanced subscription details for an account.
	Subscription *Subscription `type:"structure"`
}

// String returns the string representation
func (s DescribeSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscription sets the Subscription field's value.
func (s *DescribeSubscriptionOutput) SetSubscription(v *Subscription) *DescribeSubscriptionOutput {
	s.Subscription = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacksRequest
type ListAttacksInput struct {
	_ struct{} `type:"structure"`

	// The end of the time period for the attacks.
	EndTime *TimeRange `type:"structure"`

	// The maximum number of AttackSummary objects to be returned. If this is left
	// blank, the first 20 results will be returned.
	MaxResults *int64 `type:"integer"`

	// The ListAttacksRequest.NextMarker value from a previous call to ListAttacksRequest.
	// Pass null if this is the first call.
	NextToken *string `min:"1" type:"string"`

	// The ARN (Amazon Resource Name) of the resource that was attacked. If this
	// is left blank, all applicable resources for this account will be included.
	ResourceArns []*string `type:"list"`

	// The time period for the attacks.
	StartTime *TimeRange `type:"structure"`
}

// String returns the string representation
func (s ListAttacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListAttacksInput) SetEndTime(v *TimeRange) *ListAttacksInput {
	s.EndTime = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAttacksInput) SetMaxResults(v int64) *ListAttacksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttacksInput) SetNextToken(v string) *ListAttacksInput {
	s.NextToken = &v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *ListAttacksInput) SetResourceArns(v []*string) *ListAttacksInput {
	s.ResourceArns = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListAttacksInput) SetStartTime(v *TimeRange) *ListAttacksInput {
	s.StartTime = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacksResponse
type ListAttacksOutput struct {
	_ struct{} `type:"structure"`

	// The attack information for the specified time range.
	AttackSummaries []*AttackSummary `type:"list"`

	// The token returned by a previous call to indicate that there is more data
	// available. If not null, more results are available. Pass this value for the
	// NextMarker parameter in a subsequent call to ListAttacks to retrieve the
	// next set of items.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAttacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttacksOutput) GoString() string {
	return s.String()
}

// SetAttackSummaries sets the AttackSummaries field's value.
func (s *ListAttacksOutput) SetAttackSummaries(v []*AttackSummary) *ListAttacksOutput {
	s.AttackSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttacksOutput) SetNextToken(v string) *ListAttacksOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtectionsRequest
type ListProtectionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of Protection objects to be returned. If this is left
	// blank the first 20 results will be returned.
	MaxResults *int64 `type:"integer"`

	// The ListProtectionsRequest.NextToken value from a previous call to ListProtections.
	// Pass null if this is the first call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListProtectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProtectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProtectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProtectionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProtectionsInput) SetMaxResults(v int64) *ListProtectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProtectionsInput) SetNextToken(v string) *ListProtectionsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtectionsResponse
type ListProtectionsOutput struct {
	_ struct{} `type:"structure"`

	// If you specify a value for MaxResults and you have more Protections than
	// the value of MaxResults, AWS Shield Advanced returns a NextToken value in
	// the response that allows you to list another group of Protections. For the
	// second and subsequent ListProtections requests, specify the value of NextToken
	// from the previous response to get information about another batch of Protections.
	NextToken *string `min:"1" type:"string"`

	// The array of enabled Protection objects.
	Protections []*Protection `type:"list"`
}

// String returns the string representation
func (s ListProtectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProtectionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProtectionsOutput) SetNextToken(v string) *ListProtectionsOutput {
	s.NextToken = &v
	return s
}

// SetProtections sets the Protections field's value.
func (s *ListProtectionsOutput) SetProtections(v []*Protection) *ListProtectionsOutput {
	s.Protections = v
	return s
}

// The mitigation applied to a DDoS attack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/Mitigation
type Mitigation struct {
	_ struct{} `type:"structure"`

	// The name of the mitigation taken for this attack.
	MitigationName *string `type:"string"`
}

// String returns the string representation
func (s Mitigation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Mitigation) GoString() string {
	return s.String()
}

// SetMitigationName sets the MitigationName field's value.
func (s *Mitigation) SetMitigationName(v string) *Mitigation {
	s.MitigationName = &v
	return s
}

// An object that represents a resource that is under DDoS protection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/Protection
type Protection struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the protection.
	Id *string `min:"1" type:"string"`

	// The friendly name of the protection. For example, My CloudFront distributions.
	Name *string `min:"1" type:"string"`

	// The ARN (Amazon Resource Name) of the AWS resource that is protected.
	ResourceArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Protection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Protection) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Protection) SetId(v string) *Protection {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Protection) SetName(v string) *Protection {
	s.Name = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Protection) SetResourceArn(v string) *Protection {
	s.ResourceArn = &v
	return s
}

// The attack information for the specified SubResource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/SubResourceSummary
type SubResourceSummary struct {
	_ struct{} `type:"structure"`

	// The list of attack types and associated counters.
	AttackVectors []*SummarizedAttackVector `type:"list"`

	// The counters that describe the details of the attack.
	Counters []*SummarizedCounter `type:"list"`

	// The unique identifier (ID) of the SubResource.
	Id *string `type:"string"`

	// The SubResource type.
	Type *string `type:"string" enum:"SubResourceType"`
}

// String returns the string representation
func (s SubResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubResourceSummary) GoString() string {
	return s.String()
}

// SetAttackVectors sets the AttackVectors field's value.
func (s *SubResourceSummary) SetAttackVectors(v []*SummarizedAttackVector) *SubResourceSummary {
	s.AttackVectors = v
	return s
}

// SetCounters sets the Counters field's value.
func (s *SubResourceSummary) SetCounters(v []*SummarizedCounter) *SubResourceSummary {
	s.Counters = v
	return s
}

// SetId sets the Id field's value.
func (s *SubResourceSummary) SetId(v string) *SubResourceSummary {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *SubResourceSummary) SetType(v string) *SubResourceSummary {
	s.Type = &v
	return s
}

// Information about the AWS Shield Advanced subscription for an account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/Subscription
type Subscription struct {
	_ struct{} `type:"structure"`

	// The start time of the subscription, in the format "2016-12-16T13:50Z".
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The length, in seconds, of the AWS Shield Advanced subscription for the account.
	TimeCommitmentInSeconds *int64 `type:"long"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subscription) GoString() string {
	return s.String()
}

// SetStartTime sets the StartTime field's value.
func (s *Subscription) SetStartTime(v time.Time) *Subscription {
	s.StartTime = &v
	return s
}

// SetTimeCommitmentInSeconds sets the TimeCommitmentInSeconds field's value.
func (s *Subscription) SetTimeCommitmentInSeconds(v int64) *Subscription {
	s.TimeCommitmentInSeconds = &v
	return s
}

// A summary of information about the attack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/SummarizedAttackVector
type SummarizedAttackVector struct {
	_ struct{} `type:"structure"`

	// The list of counters that describe the details of the attack.
	VectorCounters []*SummarizedCounter `type:"list"`

	// The attack type, for example, SNMP reflection or SYN flood.
	//
	// VectorType is a required field
	VectorType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SummarizedAttackVector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SummarizedAttackVector) GoString() string {
	return s.String()
}

// SetVectorCounters sets the VectorCounters field's value.
func (s *SummarizedAttackVector) SetVectorCounters(v []*SummarizedCounter) *SummarizedAttackVector {
	s.VectorCounters = v
	return s
}

// SetVectorType sets the VectorType field's value.
func (s *SummarizedAttackVector) SetVectorType(v string) *SummarizedAttackVector {
	s.VectorType = &v
	return s
}

// The counter that describes a DDoS attack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/SummarizedCounter
type SummarizedCounter struct {
	_ struct{} `type:"structure"`

	// The average value of the counter for a specified time period.
	Average *float64 `type:"double"`

	// The maximum value of the counter for a specified time period.
	Max *float64 `type:"double"`

	// The number of counters for a specified time period.
	N *int64 `type:"integer"`

	// The counter name.
	Name *string `type:"string"`

	// The total of counter values for a specified time period.
	Sum *float64 `type:"double"`

	// The unit of the counters.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s SummarizedCounter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SummarizedCounter) GoString() string {
	return s.String()
}

// SetAverage sets the Average field's value.
func (s *SummarizedCounter) SetAverage(v float64) *SummarizedCounter {
	s.Average = &v
	return s
}

// SetMax sets the Max field's value.
func (s *SummarizedCounter) SetMax(v float64) *SummarizedCounter {
	s.Max = &v
	return s
}

// SetN sets the N field's value.
func (s *SummarizedCounter) SetN(v int64) *SummarizedCounter {
	s.N = &v
	return s
}

// SetName sets the Name field's value.
func (s *SummarizedCounter) SetName(v string) *SummarizedCounter {
	s.Name = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *SummarizedCounter) SetSum(v float64) *SummarizedCounter {
	s.Sum = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *SummarizedCounter) SetUnit(v string) *SummarizedCounter {
	s.Unit = &v
	return s
}

// The time range.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/TimeRange
type TimeRange struct {
	_ struct{} `type:"structure"`

	// The start time, in the format 2016-12-16T13:50Z.
	FromInclusive *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The end time, in the format 2016-12-16T15:50Z.
	ToExclusive *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeRange) GoString() string {
	return s.String()
}

// SetFromInclusive sets the FromInclusive field's value.
func (s *TimeRange) SetFromInclusive(v time.Time) *TimeRange {
	s.FromInclusive = &v
	return s
}

// SetToExclusive sets the ToExclusive field's value.
func (s *TimeRange) SetToExclusive(v time.Time) *TimeRange {
	s.ToExclusive = &v
	return s
}

const (
	// SubResourceTypeIp is a SubResourceType enum value
	SubResourceTypeIp = "IP"

	// SubResourceTypeUrl is a SubResourceType enum value
	SubResourceTypeUrl = "URL"
)
